/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.BlackPointEstimationMethod;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BlackPointEstimator;

public abstract class BaseMonochromeBitmapSource
implements MonochromeBitmapSource {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private final int height;
    private final int width;
    private int blackPoint;
    private BlackPointEstimationMethod lastMethod;
    private int lastArgument;
    private int[] luminances;

    protected BaseMonochromeBitmapSource(int width, int height) {
        this.height = height;
        this.width = width;
        this.blackPoint = 127;
        this.lastMethod = null;
        this.lastArgument = 0;
    }

    private void initLuminances() {
        if (this.luminances == null) {
            int height;
            int width = this.getWidth();
            int max = width > (height = this.getHeight()) ? width : height;
            this.luminances = new int[max];
        }
    }

    public boolean isBlack(int x, int y) {
        return this.getLuminance(x, y) < this.blackPoint;
    }

    public BitArray getBlackRow(int y, BitArray row, int startX, int getWidth) {
        if (row == null || row.getSize() < getWidth) {
            row = new BitArray(getWidth);
        } else {
            row.clear();
        }
        this.initLuminances();
        this.luminances = this.getLuminanceRow(y, this.luminances);
        if (this.lastMethod.equals(BlackPointEstimationMethod.ROW_SAMPLING)) {
            int left = this.luminances[startX];
            int center = this.luminances[startX + 1];
            for (int x = 1; x < getWidth - 1; ++x) {
                int right = this.luminances[startX + x + 1];
                int luminance = (center << 2) - left - right >> 1;
                if (luminance < this.blackPoint) {
                    row.set(x);
                }
                left = center;
                center = right;
            }
        } else {
            for (int x = 0; x < getWidth; ++x) {
                if (this.luminances[startX + x] >= this.blackPoint) continue;
                row.set(x);
            }
        }
        return row;
    }

    public BitArray getBlackColumn(int x, BitArray column, int startY, int getHeight) {
        if (column == null || column.getSize() < getHeight) {
            column = new BitArray(getHeight);
        } else {
            column.clear();
        }
        this.initLuminances();
        this.luminances = this.getLuminanceColumn(x, this.luminances);
        for (int y = 0; y < getHeight; ++y) {
            if (this.luminances[startY + y] >= this.blackPoint) continue;
            column.set(y);
        }
        return column;
    }

    public void estimateBlackPoint(BlackPointEstimationMethod method, int argument) throws ReaderException {
        if (!method.equals(this.lastMethod) || argument != this.lastArgument) {
            int width = this.getWidth();
            int height = this.getHeight();
            int[] histogram = new int[32];
            if (method.equals(BlackPointEstimationMethod.TWO_D_SAMPLING)) {
                int minDimension = width < height ? width : height;
                int startX = width - minDimension >> 1;
                int startY = height - minDimension >> 1;
                for (int n = 0; n < minDimension; ++n) {
                    int luminance = this.getLuminance(startX + n, startY + n);
                    int n2 = luminance >> 3;
                    histogram[n2] = histogram[n2] + 1;
                }
            } else if (method.equals(BlackPointEstimationMethod.ROW_SAMPLING)) {
                if (argument < 0 || argument >= height) {
                    throw new IllegalArgumentException("Row is not within the image: " + argument);
                }
                this.initLuminances();
                this.luminances = this.getLuminanceRow(argument, this.luminances);
                for (int x = 0; x < width; ++x) {
                    int n = this.luminances[x] >> 3;
                    histogram[n] = histogram[n] + 1;
                }
            } else {
                throw new IllegalArgumentException("Unknown method: " + method);
            }
            this.blackPoint = BlackPointEstimator.estimate(histogram) << 3;
            this.lastMethod = method;
            this.lastArgument = argument;
        }
    }

    public BlackPointEstimationMethod getLastEstimationMethod() {
        return this.lastMethod;
    }

    public MonochromeBitmapSource rotateCounterClockwise() {
        throw new IllegalArgumentException("Rotate not supported");
    }

    public boolean isRotateSupported() {
        return false;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getWidth() {
        return this.width;
    }

    protected abstract int getLuminance(int var1, int var2);

    protected abstract int[] getLuminanceRow(int var1, int[] var2);

    protected abstract int[] getLuminanceColumn(int var1, int[] var2);
}

