/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.URIParsedResult;
import com.google.zxing.client.result.optional.AbstractMobileTagResultParser;

final class MobileTagSimpleWebResultParser
extends AbstractMobileTagResultParser {
    public static final String SERVICE_TYPE = "04";
    private static final String[] URI_PREFIXES = new String[]{null, "http://", "http://www.", "https://", "https://www.", "rtsp://"};

    MobileTagSimpleWebResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        if (!result.getBarcodeFormat().equals(BarcodeFormat.DATAMATRIX)) {
            return null;
        }
        String rawText = result.getText();
        if (!rawText.startsWith(SERVICE_TYPE)) {
            return null;
        }
        String[] matches = MobileTagSimpleWebResultParser.matchDelimitedFields(rawText.substring(2), 2);
        if (matches == null) {
            return null;
        }
        String uri = matches[0];
        String title = matches[1];
        char maybePrefixChar = uri.charAt(2);
        if (maybePrefixChar >= '0' && maybePrefixChar <= '9') {
            int prefixIndex = maybePrefixChar - 48;
            uri = prefixIndex >= 1 && prefixIndex < URI_PREFIXES.length ? URI_PREFIXES[prefixIndex] + uri.substring(1) : uri.substring(1);
        }
        return new URIParsedResult(uri, title);
    }
}

