/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.optional.AbstractMobileTagResultParser;

final class MobileTagSimpleContactResultParser
extends AbstractMobileTagResultParser {
    public static final String SERVICE_TYPE = "02";

    MobileTagSimpleContactResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        if (!result.getBarcodeFormat().equals(BarcodeFormat.DATAMATRIX)) {
            return null;
        }
        String rawText = result.getText();
        if (!rawText.startsWith(SERVICE_TYPE)) {
            return null;
        }
        String[] matches = MobileTagSimpleContactResultParser.matchDelimitedFields(rawText.substring(2), 9);
        if (matches == null || !MobileTagSimpleContactResultParser.isDigits(matches[7], 8)) {
            return null;
        }
        String fullName = matches[0];
        String telephoneCell = matches[1];
        String telephone = matches[2];
        String email1 = matches[3];
        String email2 = matches[4];
        String address = matches[5];
        String org = matches[6];
        String birthday = matches[7];
        if (!MobileTagSimpleContactResultParser.isStringOfDigits(birthday, 8)) {
            return null;
        }
        String title = matches[8];
        return new AddressBookParsedResult(new String[]{fullName}, null, new String[]{telephoneCell, telephone}, new String[]{email1, email2}, null, address, org, birthday, title, null);
    }
}

