/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.optional.AbstractMobileTagResultParser;

final class MobileTagSimpleCalendarResultParser
extends AbstractMobileTagResultParser {
    public static final String SERVICE_TYPE = "07";

    MobileTagSimpleCalendarResultParser() {
    }

    public static CalendarParsedResult parse(Result result) {
        if (!result.getBarcodeFormat().equals(BarcodeFormat.DATAMATRIX)) {
            return null;
        }
        String rawText = result.getText();
        if (!rawText.startsWith(SERVICE_TYPE)) {
            return null;
        }
        String[] matches = MobileTagSimpleCalendarResultParser.matchDelimitedFields(rawText.substring(2), 6);
        if (matches == null || !MobileTagSimpleCalendarResultParser.isDigits(matches[1], 10) || !MobileTagSimpleCalendarResultParser.isDigits(matches[2], 10)) {
            return null;
        }
        String summary = matches[0];
        String start = MobileTagSimpleCalendarResultParser.expandDateString(matches[1]);
        String end = MobileTagSimpleCalendarResultParser.expandDateString(matches[2]);
        String location = matches[3];
        String attendee = matches[4];
        String title = matches[5];
        try {
            return new CalendarParsedResult(summary, start, end, location, attendee, title);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    private static String expandDateString(String date) {
        if (date == null) {
            return null;
        }
        return "20" + date.substring(0, 6) + 'T' + date.substring(6) + "00Z";
    }
}

