/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.CalendarParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.VCardResultParser;

final class VEventResultParser
extends ResultParser {
    private VEventResultParser() {
    }

    public static CalendarParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        int vEventStart = rawText.indexOf("BEGIN:VEVENT");
        if (vEventStart < 0) {
            return null;
        }
        int vEventEnd = rawText.indexOf("END:VEVENT");
        if (vEventEnd < 0) {
            return null;
        }
        String summary = VCardResultParser.matchSingleVCardPrefixedField("SUMMARY", rawText, true);
        String start = VCardResultParser.matchSingleVCardPrefixedField("DTSTART", rawText, true);
        String end = VCardResultParser.matchSingleVCardPrefixedField("DTEND", rawText, true);
        try {
            return new CalendarParsedResult(summary, start, end, null, null, null);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }
}

