/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.URIParsedResult;

final class URIResultParser
extends ResultParser {
    private URIResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        String rawText = result.getText();
        if (!URIResultParser.isBasicallyValidURI(rawText)) {
            return null;
        }
        if (rawText.startsWith("URL:")) {
            rawText = rawText.substring(4);
        }
        return new URIParsedResult(rawText, null);
    }

    static boolean isBasicallyValidURI(String uri) {
        return uri != null && uri.indexOf(32) < 0 && uri.indexOf(10) < 0 && (uri.indexOf(58) >= 0 || uri.indexOf(46) >= 0);
    }
}

