/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.client.result.SMSParsedResult;
import java.util.Hashtable;

final class SMSMMSResultParser
extends ResultParser {
    private SMSMMSResultParser() {
    }

    public static SMSParsedResult parse(Result result) {
        int bodyStart;
        String via;
        String number;
        int queryStart;
        String smsURIWithoutQuery;
        int numberEnd;
        int prefixLength;
        String rawText = result.getText();
        if (rawText == null) {
            return null;
        }
        if (rawText.startsWith("sms:") || rawText.startsWith("SMS:") || rawText.startsWith("mms:") || rawText.startsWith("MMS:")) {
            prefixLength = 4;
        } else if (rawText.startsWith("smsto:") || rawText.startsWith("SMSTO:") || rawText.startsWith("mmsto:") || rawText.startsWith("MMSTO:")) {
            prefixLength = 6;
        } else {
            return null;
        }
        Hashtable nameValuePairs = SMSMMSResultParser.parseNameValuePairs(rawText);
        String subject = null;
        String body = null;
        boolean querySyntax = false;
        if (nameValuePairs != null && !nameValuePairs.isEmpty()) {
            subject = (String)nameValuePairs.get("subject");
            body = (String)nameValuePairs.get("body");
            querySyntax = true;
        }
        if ((numberEnd = (smsURIWithoutQuery = (queryStart = rawText.indexOf(63, prefixLength)) < 0 || !querySyntax ? rawText.substring(prefixLength) : rawText.substring(prefixLength, queryStart)).indexOf(59)) < 0) {
            number = smsURIWithoutQuery;
            via = null;
        } else {
            number = smsURIWithoutQuery.substring(0, numberEnd);
            String maybeVia = smsURIWithoutQuery.substring(numberEnd + 1);
            via = maybeVia.startsWith("via=") ? maybeVia.substring(4) : null;
        }
        if (body == null && (bodyStart = number.indexOf(58)) >= 0) {
            body = number.substring(bodyStart + 1);
            number = number.substring(0, bodyStart);
        }
        return new SMSParsedResult("sms:" + number, number, via, subject, body, null);
    }
}

