/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookAUResultParser;
import com.google.zxing.client.result.AddressBookDoCoMoResultParser;
import com.google.zxing.client.result.BizcardResultParser;
import com.google.zxing.client.result.BookmarkDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressResultParser;
import com.google.zxing.client.result.EmailDoCoMoResultParser;
import com.google.zxing.client.result.GeoResultParser;
import com.google.zxing.client.result.ISBNResultParser;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductResultParser;
import com.google.zxing.client.result.SMSMMSResultParser;
import com.google.zxing.client.result.TelResultParser;
import com.google.zxing.client.result.TextParsedResult;
import com.google.zxing.client.result.URIResultParser;
import com.google.zxing.client.result.URLTOResultParser;
import com.google.zxing.client.result.VCardResultParser;
import com.google.zxing.client.result.VEventResultParser;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ResultParser {
    public static ParsedResult parseResult(Result theResult) {
        ParsedResult result = BookmarkDoCoMoResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = AddressBookDoCoMoResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = EmailDoCoMoResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = AddressBookAUResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = VCardResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = BizcardResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = VEventResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = EmailAddressResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = TelResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = SMSMMSResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = GeoResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = URLTOResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = URIResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = ISBNResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        result = ProductResultParser.parse(theResult);
        if (result != null) {
            return result;
        }
        return new TextParsedResult(theResult.getText(), null);
    }

    protected static void maybeAppend(String value, StringBuffer result) {
        if (value != null) {
            result.append('\n');
            result.append(value);
        }
    }

    protected static void maybeAppend(String[] value, StringBuffer result) {
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                result.append('\n');
                result.append(value[i]);
            }
        }
    }

    protected static String[] maybeWrap(String value) {
        String[] stringArray;
        if (value == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = value;
        }
        return stringArray;
    }

    protected static String unescapeBackslash(String escaped) {
        int backslash;
        if (escaped != null && (backslash = escaped.indexOf(92)) >= 0) {
            int max = escaped.length();
            StringBuffer unescaped = new StringBuffer(max - 1);
            unescaped.append(escaped.toCharArray(), 0, backslash);
            boolean nextIsEscaped = false;
            for (int i = backslash; i < max; ++i) {
                char c = escaped.charAt(i);
                if (nextIsEscaped || c != '\\') {
                    unescaped.append(c);
                    nextIsEscaped = false;
                    continue;
                }
                nextIsEscaped = true;
            }
            return unescaped.toString();
        }
        return escaped;
    }

    static String urlDecode(String escaped) {
        if (escaped == null) {
            return null;
        }
        char[] escapedArray = escaped.toCharArray();
        int first = ResultParser.findFirstEscape(escapedArray);
        if (first < 0) {
            return escaped;
        }
        int max = escapedArray.length;
        StringBuffer unescaped = new StringBuffer(max - 2);
        unescaped.append(escapedArray, 0, first);
        for (int i = first; i < max; ++i) {
            char c = escapedArray[i];
            if (c == '+') {
                unescaped.append(' ');
                continue;
            }
            if (c == '%') {
                if (i >= max - 2) {
                    unescaped.append('%');
                    continue;
                }
                int firstDigitValue = ResultParser.parseHexDigit(escapedArray[++i]);
                int secondDigitValue = ResultParser.parseHexDigit(escapedArray[++i]);
                if (firstDigitValue < 0 || secondDigitValue < 0) {
                    unescaped.append('%');
                    unescaped.append(escapedArray[i - 1]);
                    unescaped.append(escapedArray[i]);
                }
                unescaped.append((char)((firstDigitValue << 4) + secondDigitValue));
                continue;
            }
            unescaped.append(c);
        }
        return unescaped.toString();
    }

    private static int findFirstEscape(char[] escapedArray) {
        int max = escapedArray.length;
        for (int i = 0; i < max; ++i) {
            char c = escapedArray[i];
            if (c != '+' && c != '%') continue;
            return i;
        }
        return -1;
    }

    private static int parseHexDigit(char c) {
        if (c >= 'a') {
            if (c <= 'f') {
                return 10 + (c - 97);
            }
        } else if (c >= 'A') {
            if (c <= 'F') {
                return 10 + (c - 65);
            }
        } else if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    protected static boolean isStringOfDigits(String value, int length) {
        if (value == null) {
            return false;
        }
        int stringLength = value.length();
        if (length != stringLength) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static Hashtable parseNameValuePairs(String uri) {
        int paramEnd;
        int paramStart = uri.indexOf(63);
        if (paramStart < 0) {
            return null;
        }
        Hashtable result = new Hashtable(3);
        ++paramStart;
        while ((paramEnd = uri.indexOf(38, paramStart)) >= 0) {
            ResultParser.appendKeyValue(uri, paramStart, paramEnd, result);
            paramStart = paramEnd + 1;
        }
        ResultParser.appendKeyValue(uri, paramStart, uri.length(), result);
        return result;
    }

    private static void appendKeyValue(String uri, int paramStart, int paramEnd, Hashtable result) {
        int separator = uri.indexOf(61, paramStart);
        if (separator >= 0) {
            String key = uri.substring(paramStart, separator);
            String value = uri.substring(separator + 1, paramEnd);
            value = ResultParser.urlDecode(value);
            result.put(key, value);
        }
    }

    static String[] matchPrefixedField(String prefix, String rawText, char endChar, boolean trim) {
        Vector<String> matches = null;
        int i = 0;
        int max = rawText.length();
        while (i < max && (i = rawText.indexOf(prefix, i)) >= 0) {
            int start = i += prefix.length();
            boolean done = false;
            while (!done) {
                if ((i = rawText.indexOf(endChar, i)) < 0) {
                    i = rawText.length();
                    done = true;
                    continue;
                }
                if (rawText.charAt(i - 1) == '\\') {
                    ++i;
                    continue;
                }
                if (matches == null) {
                    matches = new Vector<String>(3);
                }
                String element = ResultParser.unescapeBackslash(rawText.substring(start, i));
                if (trim) {
                    element = element.trim();
                }
                matches.addElement(element);
                ++i;
                done = true;
            }
        }
        if (matches == null || matches.isEmpty()) {
            return null;
        }
        return ResultParser.toStringArray(matches);
    }

    static String matchSinglePrefixedField(String prefix, String rawText, char endChar, boolean trim) {
        String[] matches = ResultParser.matchPrefixedField(prefix, rawText, endChar, trim);
        return matches == null ? null : matches[0];
    }

    static String[] toStringArray(Vector strings) {
        int size = strings.size();
        String[] result = new String[size];
        for (int j = 0; j < size; ++j) {
            result[j] = (String)strings.elementAt(j);
        }
        return result;
    }
}

