/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookParsedResult;
import com.google.zxing.client.result.ResultParser;
import java.util.Vector;

final class AddressBookAUResultParser
extends ResultParser {
    AddressBookAUResultParser() {
    }

    public static AddressBookParsedResult parse(Result result) {
        String rawText = result.getText();
        if (rawText == null || rawText.indexOf("MEMORY") < 0 || rawText.indexOf("\r\n") < 0) {
            return null;
        }
        String name = AddressBookAUResultParser.matchSinglePrefixedField("NAME1:", rawText, '\r', true);
        String pronunciation = AddressBookAUResultParser.matchSinglePrefixedField("NAME2:", rawText, '\r', true);
        String[] phoneNumbers = AddressBookAUResultParser.matchMultipleValuePrefix("TEL", 3, rawText, true);
        String[] emails = AddressBookAUResultParser.matchMultipleValuePrefix("MAIL", 3, rawText, true);
        String note = AddressBookAUResultParser.matchSinglePrefixedField("MEMORY:", rawText, '\r', false);
        String address = AddressBookAUResultParser.matchSinglePrefixedField("ADD:", rawText, '\r', true);
        return new AddressBookParsedResult(AddressBookAUResultParser.maybeWrap(name), pronunciation, phoneNumbers, emails, note, address, null, null, null, null);
    }

    private static String[] matchMultipleValuePrefix(String prefix, int max, String rawText, boolean trim) {
        String value;
        Vector<String> values = null;
        for (int i = 1; i <= max && (value = AddressBookAUResultParser.matchSinglePrefixedField(prefix + i + ':', rawText, '\r', trim)) != null; ++i) {
            if (values == null) {
                values = new Vector<String>(max);
            }
            values.addElement(value);
        }
        if (values == null) {
            return null;
        }
        return AddressBookAUResultParser.toStringArray(values);
    }
}

