/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.oned.MultiFormatOneDReader;
import com.google.zxing.qrcode.QRCodeReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatReader
implements Reader {
    private Hashtable hints;
    private Vector readers;

    public Result decode(MonochromeBitmapSource image) throws ReaderException {
        this.setHints(null);
        return this.decodeInternal(image);
    }

    public Result decode(MonochromeBitmapSource image, Hashtable hints) throws ReaderException {
        this.setHints(hints);
        return this.decodeInternal(image);
    }

    public Result decodeWithState(MonochromeBitmapSource image) throws ReaderException {
        if (this.readers == null) {
            this.setHints(null);
        }
        return this.decodeInternal(image);
    }

    public void setHints(Hashtable hints) {
        this.hints = hints;
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        Vector possibleFormats = hints == null ? null : (Vector)hints.get(DecodeHintType.POSSIBLE_FORMATS);
        this.readers = new Vector();
        if (possibleFormats != null) {
            boolean addOneDReader;
            boolean bl = addOneDReader = possibleFormats.contains(BarcodeFormat.UPC_A) || possibleFormats.contains(BarcodeFormat.UPC_E) || possibleFormats.contains(BarcodeFormat.EAN_13) || possibleFormats.contains(BarcodeFormat.EAN_8) || possibleFormats.contains(BarcodeFormat.CODE_39) || possibleFormats.contains(BarcodeFormat.CODE_128) || possibleFormats.contains(BarcodeFormat.ITF);
            if (addOneDReader && !tryHarder) {
                this.readers.addElement(new MultiFormatOneDReader(hints));
            }
            if (possibleFormats.contains(BarcodeFormat.QR_CODE)) {
                this.readers.addElement(new QRCodeReader());
            }
            if (addOneDReader && tryHarder) {
                this.readers.addElement(new MultiFormatOneDReader(hints));
            }
        }
        if (this.readers.isEmpty()) {
            if (!tryHarder) {
                this.readers.addElement(new MultiFormatOneDReader(hints));
            }
            this.readers.addElement(new QRCodeReader());
            if (tryHarder) {
                this.readers.addElement(new MultiFormatOneDReader(hints));
            }
        }
    }

    private Result decodeInternal(MonochromeBitmapSource image) throws ReaderException {
        int size = this.readers.size();
        for (int i = 0; i < size; ++i) {
            Reader reader = (Reader)this.readers.elementAt(i);
            try {
                return reader.decode(image, this.hints);
            }
            catch (ReaderException re) {
                continue;
            }
        }
        throw ReaderException.getInstance();
    }
}

