package com.geopushnetwork.sdk;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import com.estimote.sdk.BeaconManager;
import com.estimote.sdk.Region;
import com.estimote.sdk.Beacon;
import java.util.List;
import android.app.PendingIntent;
import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;

import java.util.UUID;

public class IBeaconService extends Service {

    public IBeaconService() {
    }

    private BeaconManager beaconManager;
    private String LOG = "";

    @Override
    public void onCreate() {
        super.onCreate();
        beaconManager = new BeaconManager(getApplicationContext());


        // add this below:
        beaconManager.connect(new BeaconManager.ServiceReadyCallback() {
            @Override
            public void onServiceReady() {

                beaconManager.startMonitoring(new Region(
                        "monitored region",
                        UUID.fromString("B9407F30-F5F8-466E-AFF9-25556B57FE6D"),
                        null, null));
                //beaconManager.setBackgroundScanPeriod();

                beaconManager.setMonitoringListener(new BeaconManager.MonitoringListener() {
                    @Override
                    public void onEnteredRegion(Region region, List<Beacon> list) {
                        String uuid = region.getProximityUUID().toString();
                        String major = String.valueOf(list.get(0).getMajor());
                        String minor = String.valueOf(list.get(0).getMinor());

                        //new GPNLib.BeaconSync(getApplicationContext()).execute(uuid, major, minor);

                        //enviar beacon para backend
                        //este devera logar a posicao do device
                        //retornar eventual oferta
                        //montar notificação
                        /*showNotification(
                                "Your gate closes in 47 minutes.",
                                "Current security wait time is 15 minutes, "
                                        + "and it's a 5 minute walk from security to the gate. "
                                        + "Looks like you've got plenty of time!");*/
                    }

                    @Override
                    public void onExitedRegion(Region region) {
                        //showNotification("Saiu", "Saiu");
                    }
                });
            }
        });
    }

    public void showNotification(String title, String message) {
        Intent notifyIntent = new Intent(this, OfferDetailActivity.class);
        notifyIntent.putExtra("ID", "pus-814d68e0-6dcf-11e5-8b45-7f8c1ae46cb0");
        notifyIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
        PendingIntent pendingIntent = PendingIntent.getActivities(this, 0,
                new Intent[] { notifyIntent }, PendingIntent.FLAG_UPDATE_CURRENT);
        Notification notification = new Notification.Builder(this)
                .setSmallIcon(android.R.drawable.ic_dialog_info)
                .setContentTitle(title)
                .setContentText(message)
                .setAutoCancel(true)
                .setContentIntent(pendingIntent)
                .build();
        notification.defaults |= Notification.DEFAULT_SOUND;
        NotificationManager notificationManager =
                (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        notificationManager.notify(1, notification);
    }

    @Override
    public IBinder onBind(Intent intent) {
        // TODO: Return the communication channel to the service.
        throw new UnsupportedOperationException("Not yet implemented");
    }
}
