package com.geopushnetwork.sdk;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.support.v7.app.ActionBar;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.BitmapFactory;

import java.nio.channels.Channel;
import java.util.List;

import com.geopushnetwork.sdk.data.SDKDataContract;
import com.geopushnetwork.sdk.sync.GPNSyncAdapter;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import com.amazonaws.mobileconnectors.amazonmobileanalytics.*;

import android.widget.ListView;
import android.widget.AdapterView;

import java.util.ArrayList;
import java.util.Vector;
import android.content.ContentResolver;

public class GPNLib {

    private static MobileAnalyticsManager analytics;

    private static String deviceId = "";
    public static String advertiserTel = "";
    public static String offerText = "";
    public static double latitude = 0;
    public static double longitude = 0;
    public static String version = "0.1";
    public static String channelId = "";

    private static String FilterCategory = "";
    private static String FilterByDate = "Y";
    private static String FilterByTime ="Y";
    private static String FilterAdvertiserId = "";
    private static String FilterChannel = "";

    private static void setDeviceId(Context applicationContext){
        String LOG = "GPN";
        if (deviceId == ""){
            AdvertisingIdClient.Info adInfo = null;
            try {
                adInfo = AdvertisingIdClient.getAdvertisingIdInfo(applicationContext);
            } catch (IOException e) {
                Log.e(LOG, e.toString());
            } catch (GooglePlayServicesNotAvailableException e) {
                Log.e(LOG, e.toString());
            } catch (IllegalStateException e) {
                Log.e(LOG, e.toString());
            } catch (GooglePlayServicesRepairableException e) {
                Log.e(LOG, e.toString());
            }
            if (adInfo == null){
                final TelephonyManager tm = (TelephonyManager) applicationContext.getSystemService(Context.TELEPHONY_SERVICE);
                deviceId = tm.getDeviceId();
            }else{
                if (adInfo.isLimitAdTrackingEnabled()){
                    final TelephonyManager tm = (TelephonyManager) applicationContext.getSystemService(Context.TELEPHONY_SERVICE);
                    deviceId = tm.getDeviceId();
                } else {
                    deviceId = adInfo.getId();
                }
            }
        }
    }

    public static class Initialize {

        private Context appContext;

        public Initialize(Context context, String channel, boolean syncNow, boolean registerSync,
                          boolean beaconMonitoring, String category, String filterByDate, String filterByTime,
                          String advertiserId, String analyticsId){
            appContext = context;
            channelId = channel;
            SDKDataContract.Initialize(appContext.getPackageName() + ".gpn");
            setDeviceId(context);
            FilterCategory = category;
            FilterByDate = filterByDate;
            FilterByTime = filterByTime;
            FilterAdvertiserId = advertiserId;
            FilterChannel = channel;


            if (syncNow){
                GPNSyncAdapter.syncImmediately(context);
            }

            if (registerSync){
                GPNSyncAdapter.initializeSyncAdapter(context);
            }


            if (beaconMonitoring){
                //start beacon monitoring
                context.startService(new Intent(context, IBeaconService.class));
            }



            try {
                analytics = MobileAnalyticsManager.getOrCreateInstance(
                        appContext,
                        analyticsId,//"79c21bf1b00c4a4bbcbf18e2128d6ff3", //Amazon Mobile Analytics App ID
                        "us-east-1:14926d1a-3756-4722-a887-3f9344b7be1e" //Amazon Cognito Identity Pool ID
                );
            } catch(InitializationException ex) {
                Log.e(this.getClass().getName(), "Failed to initialize Amazon Mobile Analytics", ex);
            }

        }

    }

    public static class Pause {
        public Pause() {
            if (analytics != null) {
                analytics.getSessionClient().pauseSession();
                analytics.getEventClient().submitEvents();
            }
        }
    }

    public static class Resume {
        public Resume(Context appContext) {
            if(analytics != null) {
                analytics.getSessionClient().resumeSession();
            }

            new GPNLib.RequestOfferList(appContext).execute();
        }
    }

    public static class RefreshData {

        private Context appContext;

        public RefreshData(Context context){
            appContext = context;
            setDeviceId(context);
            GPNSyncAdapter.syncImmediately(context);

        }

    }

    public static class RequestCupom extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;
        private ScrollView scrollView;
        private String adId;

        public RequestCupom(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected JSONObject doInBackground(String... params) {
            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;
            String description = params[0];
            adId = params[1];

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/generateCupom";
                final String DEVICE_ID = "deviceId";
                final String DESCRIPTION = "description";
                final String AD_ID = "adId";

                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .appendQueryParameter(DESCRIPTION, description)
                        .appendQueryParameter(AD_ID, adId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(true);
            cp.setVisibility(View.VISIBLE);
            scrollView = (ScrollView)  activity.findViewById(R.id.scrollView);
            scrollView.setAlpha((float) 0.15);
        }

        @Override
        protected void onPostExecute(JSONObject jsonObject) {
            super.onPostExecute(jsonObject);
            final Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(false);
            if (jsonObject != null) {
                Toast.makeText(appContext, "Cupom gerado com sucesso", Toast.LENGTH_LONG).show();
                new GetAddDetail(appContext, false, "").execute(adId);
            } else {
                Toast.makeText(appContext,
                        "Ocorreu um erro ao gerar o cupom", Toast.LENGTH_LONG).show();
            }
        }
    }

    public static class RequestCupomList extends AsyncTask<Void, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;

        public RequestCupomList(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected JSONObject doInBackground(Void... params) {
            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/getCupons";
                final String DEVICE_ID = "deviceId";

                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObj = new JSONObject(jsonStr);
                return jsonObj;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(true);
            cp.setVisibility(View.VISIBLE);
        }

        @Override
        protected void onPostExecute(JSONObject jsonObj) {
            super.onPostExecute(jsonObj);
            final Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(false);
            cp.setVisibility(View.INVISIBLE);

            try {
                JSONArray jsonArray = jsonObj.getJSONArray("d");
                if (jsonObj != null) {
                    //populate list
                    final ArrayList<Cupom> list = new ArrayList<Cupom>();
                    for (int i = 0; i < jsonArray.length(); i++) {
                        try {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            Cupom cupom = new Cupom();
                            cupom.code = obj.getString("code");
                            cupom.title = obj.getString("t");
                            cupom.adid = obj.getString("adid");
                            list.add(cupom);
                        } catch (JSONException exc) {
                            Log.e(LOG, exc.toString());
                        }
                    }

                    ListView mListView = (ListView) activity.findViewById(R.id.listView);

                    CupomAdapter adapter = new CupomAdapter(appContext, list);
                    mListView.setAdapter(adapter);
                    mListView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                        @Override
                        public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                            Intent intent = new Intent(activity.getApplicationContext(), CupomActivity.class);
                            intent.putExtra("CUPOM_CODE", list.get(position).code);
                            activity.startActivity(intent);
                        }
                    });
                    adapter.notifyDataSetChanged();
                } else {
                    Toast.makeText(appContext,
                            "Ocorreu um erro ao carregar as informações", Toast.LENGTH_LONG).show();
                }
            } catch(JSONException exc){
                Toast.makeText(appContext,
                        "Ocorreu um erro ao carregar as informações", Toast.LENGTH_LONG).show();
            }
        }
    }

    public static class RequestOfferList extends AsyncTask<Void, Void, JSONArray> {

        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;


        public RequestOfferList(Context context){
            appContext = context;
        }

        @Override
        protected JSONArray doInBackground(Void... params) {
            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/sync";
                final String DEVICE_ID = "uuid";
                final String LATITUDE = "lat";
                final String LONGITUDE = "lon";
                final String VERSION = "v";
                final String OS = "os";
                final String CHANNEL = "cha";
                final String ADVERTISER = "adv";
                final String CATEGORY = "cat";
                final String SUBCATEGORY = "scat";
                final String FILTERBYDATE = "fd";
                final String FILTERBYTIME = "ft";
                final String STATUS = "s";

                if (FilterAdvertiserId == null){
                    FilterAdvertiserId = "";
                }

                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .appendQueryParameter(LATITUDE, String.valueOf(latitude))
                        .appendQueryParameter(LONGITUDE, String.valueOf(longitude))
                        .appendQueryParameter(VERSION, version)
                        .appendQueryParameter(OS, "android")
                        .appendQueryParameter(CHANNEL, FilterChannel)
                        .appendQueryParameter(ADVERTISER, FilterAdvertiserId)
                        .appendQueryParameter(CATEGORY, FilterCategory)
                        .appendQueryParameter(FILTERBYDATE, FilterByDate)
                        .appendQueryParameter(FILTERBYTIME, FilterByTime)
                        .appendQueryParameter(STATUS, "ALL")
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setConnectTimeout(10000);
                urlConnection.setReadTimeout(10000);
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObj = new JSONObject(jsonStr);
                JSONArray jsonArray = jsonObj.getJSONArray("d");
                return jsonArray;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            /*Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(true);
            cp.setVisibility(View.VISIBLE);*/
        }

        @Override
        protected void onPostExecute(JSONArray jsonArray) {
            super.onPostExecute(jsonArray);

            if (jsonArray != null) {

                Vector<ContentValues> cVVector = new Vector<ContentValues>(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); i++) {
                    try {
                        JSONObject obj = jsonArray.getJSONObject(i);
                        JSONObject adv = obj.getJSONObject("adv");
                        ContentValues adValues = new ContentValues();
                        adValues.put(SDKDataContract.AdEntry.COLUMN_ID, obj.getString("id"));
                        adValues.put(SDKDataContract.AdEntry.COLUMN_TITLE, obj.getString("t"));
                        adValues.put(SDKDataContract.AdEntry.COLUMN_ADVERTISER, adv.getString("n"));
                        adValues.put(SDKDataContract.AdEntry.COLUMN_CATEGORY, adv.getString("scat"));

                        adValues.put(SDKDataContract.AdEntry.COLUMN_DISCOUNT, obj.getDouble("d"));

                        double distance = adv.getDouble("di") * 1000;
                        adValues.put(SDKDataContract.AdEntry.COLUMN_DISTANCE, distance);
                        adValues.put(SDKDataContract.AdEntry.COLUMN_OLDPRICE, obj.getDouble("o"));
                        adValues.put(SDKDataContract.AdEntry.COLUMN_NEWPRICE, obj.getDouble("n"));
                        adValues.put(SDKDataContract.AdEntry.COLUMN_COVER_IMAGE, obj.getString("cm"));


                        cVVector.add(adValues);
                    } catch (JSONException exc) {
                        Log.e(LOG, exc.toString());
                    }
                }

                // clean database
                ContentResolver c = appContext.getContentResolver();
                if (SDKDataContract.AdEntry.CONTENT_URI == null){
                    SDKDataContract.Initialize(appContext.getPackageName() + ".gpn");
                }
                c.delete(SDKDataContract.AdEntry.CONTENT_URI, null, null);

                if (cVVector.size() > 0) {
                    ContentValues[] cvArray = new ContentValues[cVVector.size()];
                    cVVector.toArray(cvArray);
                    appContext.getContentResolver().bulkInsert(SDKDataContract.AdEntry.CONTENT_URI, cvArray);
                }

                Log.d(LOG, "Sync Complete. " + cVVector.size() + " Inserted");


            } else {
                //Toast.makeText(appContext,
                //        "Ocorreu um erro ao carregar as informações", Toast.LENGTH_LONG).show();
            }

        }
    }

    public static class GetAddDetail extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;
        private ScrollView scrollView;
        public static double advertiserLatitude = 0;
        public static double advertiserLongitude = 0;
        private static boolean Admin = false;
        private String adId = "";
        private static String Token = "";

        public GetAddDetail(Context context, boolean admin, String token){
            appContext = context;
            GPNLib.setDeviceId(appContext);
            Admin = admin;
            Token = token;

        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;
            adId = params[0];

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/getDetail";
                final String _ID = "id";
                final String DEVICE_ID = "deviceId";

                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(_ID, adId)
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(true);
            cp.setVisibility(View.VISIBLE);
            scrollView = (ScrollView)  activity.findViewById(R.id.scrollView);
            scrollView.setAlpha((float) 0.15);
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
            final AppCompatActivity activity = (AppCompatActivity) appContext;
            cp = (ProgressBar) activity.findViewById(R.id.progressBar);
            cp.setIndeterminate(false);
            JSONObject advObject;

            ActionBar actionBar = activity.getSupportActionBar();

            if (jsonObject != null) {
                try {
                    advObject = jsonObject.getJSONObject("adv");
                    String advertiserName =advObject.getString("n");
                    actionBar.setTitle(advertiserName);

                } catch (JSONException exc) {
                    advObject = new JSONObject();
                }

                //setando o advertiser phone
                try {
                    advertiserTel = advObject.getString("te");
                } catch (JSONException exc) {
                    advertiserTel = "";
                    Log.e(LOG, exc.toString());
                }

                //set offer text to intent share
                try {
                    offerText = jsonObject.getString("t");
                } catch (JSONException exc) {
                    offerText = "";
                    Log.e(LOG, exc.toString());
                }


                //setando offer
                TextView mOfferText = (TextView) activity.findViewById(R.id.gpn_sdk_offer_detail__textview_offerText);
                try {
                    mOfferText.setText(jsonObject.getString("t"));
                } catch (JSONException exc) {
                    mOfferText.setText("-");
                    Log.e(LOG, exc.toString());
                }

                //setando ondPrice
                TextView mOldPrice = (TextView) activity.findViewById(R.id.gpn_sdk_offer_detail__textview_oldPrice);
                try {
                    mOldPrice.setText("De " + DecimalFormat.getCurrencyInstance().format(jsonObject.getDouble("o")));
                } catch (JSONException exc) {
                    mOldPrice.setText("-");
                    Log.e(LOG, exc.toString());
                }

                //setando newPrice
                TextView mNewPrice = (TextView) activity.findViewById(R.id.gpn_sdk_offer_detail__textview_newPrice);
                try {
                    mNewPrice.setText("Por " + DecimalFormat.getCurrencyInstance().format(jsonObject.getDouble("n")));
                } catch (JSONException exc) {
                    mNewPrice.setText("-");
                    Log.e(LOG, exc.toString());
                }

                //handle button
                Button mActionButton = (Button) activity.findViewById(R.id.gpn_sdk_offer_detail_button_btnCupom);
                if (!Admin) {
                    try {
                        if (jsonObject.getInt("rc") > 0) {
                            if (jsonObject.getString("cc") != "null") {
                                mActionButton.setText("Visualizar Cupom");
                                mActionButton.setVisibility(View.VISIBLE);
                                mActionButton.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {

                                        try {
                                            Intent intent = new Intent(appContext, CupomActivity.class);
                                            intent.putExtra("CUPOM_CODE", jsonObject.getString("cc"));
                                            activity.startActivity(intent);
                                        } catch (JSONException exc) {
                                            Toast.makeText(appContext, "Erro ao apresentar o cupom.", Toast.LENGTH_LONG).show();
                                            Log.e(LOG, exc.toString());
                                        }
                                    }
                                });
                            } else {
                                mActionButton.setText("Gerar Cupom");
                                mActionButton.setVisibility(View.VISIBLE);

                                //gerar cupom
                                mActionButton.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        try {
                                            new RequestCupom(appContext).execute(
                                                    jsonObject.getString("t"),
                                                    jsonObject.getString("id"));
                                        } catch (JSONException exc) {
                                            Log.e(LOG, exc.toString());
                                        }

                                    }
                                });
                            }
                        } else {
                            if (jsonObject.getString("cc") != "null") {
                                mActionButton.setText("Visualizar Cupom");
                                mActionButton.setVisibility(View.VISIBLE);
                                mActionButton.setOnClickListener(new View.OnClickListener() {
                                    @Override
                                    public void onClick(View v) {
                                        try {
                                            Intent intent = new Intent(appContext, CupomActivity.class);
                                            intent.putExtra("CUPOM_CODE", jsonObject.getString("cc"));
                                            activity.startActivity(intent);
                                        } catch (JSONException exc) {
                                            Toast.makeText(appContext, "Erro ao apresentar o cupom.", Toast.LENGTH_LONG).show();
                                            Log.e(LOG, exc.toString());
                                        }
                                    }
                                });
                            } else {
                                mActionButton.setVisibility(View.INVISIBLE);
                            }
                        }

                    } catch (JSONException exc) {
                        Log.e(LOG, exc.toString());
                    }
                } else {
                    try {
                        if (jsonObject.getString("s").equalsIgnoreCase("ACTIVE")) {
                            mActionButton.setText("Pausar");
                            mActionButton.setOnClickListener(null);
                            mActionButton.setOnClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    new PauseAd(appContext, adId, Token).execute();
                                }
                            });
                        } else {
                            mActionButton.setText("Ativar");
                            mActionButton.setOnClickListener(null);
                            mActionButton.setOnClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    new ResumeAd(appContext, adId, Token).execute();

                                }
                            });
                        }
                    }catch (JSONException exc){
                        Log.e(LOG, exc.toString());
                    }

                }


                //setando validade
                TextView mValidUntil = (TextView) activity.findViewById(R.id.gpn_sdk_offer_detail__textview_validuntil);
                try {
                    mValidUntil.setText(jsonObject.getString("v"));
                } catch (JSONException exc) {
                    mValidUntil.setText("-");
                    Log.e(LOG, exc.toString());
                }

                //setando regulamento
                TextView mRegulamento = (TextView) activity.findViewById(R.id.gpn_sdk_offer_detail__textview_generalRules);
                try {
                    mRegulamento.setText(jsonObject.getString("r"));
                } catch (JSONException exc) {
                    mRegulamento.setText("-");
                    Log.e(LOG, exc.toString());
                }

                try {
                    //setting latitude and longitude
                    advertiserLatitude = advObject.getDouble("la");
                    advertiserLongitude = advObject.getDouble("lo");
                } catch (JSONException exc) {
                    Log.e(LOG, exc.toString());
                }

                //setando a imagem

                try {
                    new SetImageInBackground(appContext).execute(
                            jsonObject.getString("im")
                    );
                } catch (JSONException exc) {
                    Log.e(LOG, exc.toString());
                }
            } else {
                Toast.makeText(appContext,
                        "Ocorreu um erro ao carregar as informações", Toast.LENGTH_LONG).show();
            }

            scrollView.setAlpha(1);
            cp.setVisibility(View.INVISIBLE);


        }

    }

    public static class SetImageInBackground extends AsyncTask<String, Void, BitmapDrawable> {

        private final String LOG = "GPN";
        private Context appContext;

        public SetImageInBackground(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected BitmapDrawable doInBackground(String... params) {

            final Activity activity = (Activity) appContext;
            final String url = params[0];


            //setando a imagem
            try {
                BitmapDrawable bitmapDrawable = new BitmapDrawable(BitmapFactory.decodeStream(
                        new URL(url).openStream()));
                return bitmapDrawable;
            } catch (MalformedURLException exc){
                Log.e(LOG, exc.toString());
            } catch (IOException exc){
                Log.e(LOG, exc.toString());
            }

            return null;

        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final BitmapDrawable img) {
            final Activity activity = (Activity) appContext;
            ImageView imageView = (ImageView) activity.findViewById(R.id.innerImage);
            imageView.setImageDrawable(img);

        }

    }

    public static class BeaconSync extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;

        public BeaconSync(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;
            String adId = params[0];

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/syncBeacon";


                final String DEVICE_ID = "uuid";
                final String BEACON_UUID = "beaconuuid";
                final String BEACON_MAJOR = "major";
                final String BEACON_MINOR = "minor";
                final String CHANNEL = "cha";
                final String VERSION = "v";
                final String OS = "os";
                String uuid = params[0].toUpperCase();
                String major = params[1];
                String minor = params[2];


                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .appendQueryParameter(BEACON_UUID, uuid)
                        .appendQueryParameter(BEACON_MAJOR, major)
                        .appendQueryParameter(BEACON_MINOR, minor)
                        .appendQueryParameter(CHANNEL, channelId)
                        .appendQueryParameter(VERSION, version)
                        .appendQueryParameter(OS, "android")
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
           super.onPostExecute(jsonObject);
            //Log.v(LOG, jsonObject.toString());

            if (jsonObject != null) {
                try {
                    Intent notifyIntent = new Intent(appContext, OfferDetailActivity.class);
                    notifyIntent.putExtra("ID", jsonObject.getString("id"));
                    notifyIntent.setFlags(Intent.FLAG_ACTIVITY_SINGLE_TOP);
                    PendingIntent pendingIntent = PendingIntent.getActivities(appContext, 0,
                            new Intent[]{notifyIntent}, PendingIntent.FLAG_UPDATE_CURRENT);

                    int icon = appContext.getResources().getIdentifier("ic_launcher", "mipmap", appContext.getPackageName());
                    Notification notification = new Notification.Builder(appContext)
                            .setSmallIcon(icon)
                            .setContentTitle(jsonObject.getString("t"))
                            .setContentText(jsonObject.getString("m"))
                            .setAutoCancel(true)
                            .setContentIntent(pendingIntent)
                            .build();
                    notification.defaults |= Notification.DEFAULT_SOUND;
                    NotificationManager notificationManager =
                            (NotificationManager) appContext.getSystemService(Context.NOTIFICATION_SERVICE);
                    notificationManager.notify(1, notification);
                } catch (JSONException exc) {
                    Log.e(LOG, exc.toString());
                }
            }
        }

    }

    public static class RegisterCall extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;

        public RegisterCall(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;
            String adId = params[0];

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/registerCall";


                final String DEVICE_ID = "deviceId";
                final String AD_ID = "adid";


                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .appendQueryParameter(AD_ID, adId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
            super.onPostExecute(jsonObject);
        }

    }

    public static class PauseAd extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;
        private String Token = "";
        private String AdId = "";

        public PauseAd(Context context, String adId, String token){
            appContext = context;
            GPNLib.setDeviceId(appContext);
            AdId = adId;
            Token = token;
        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/pausead";


                final String TOKEN = "token";
                final String AD_ID = "adid";


                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(TOKEN, Token)
                        .appendQueryParameter(AD_ID, AdId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
            super.onPostExecute(jsonObject);
            Activity activity = (Activity) appContext;
            Button mActionButton = (Button) activity.findViewById(R.id.gpn_sdk_offer_detail_button_btnCupom);
            try {
                if (jsonObject.getInt("s") == 200) {
                    mActionButton.setText("Ativar");
                    mActionButton.setOnClickListener(null);
                    mActionButton.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            new ResumeAd(appContext, AdId, Token).execute();
                        }
                    });
                } else {
                    Toast.makeText(appContext, "Erro ao pausar campanha", Toast.LENGTH_SHORT).show();
                }
            }catch (JSONException exc){
                Log.e(LOG, exc.toString());
            }
        }

    }

    public static class ResumeAd extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;
        private String AdId = "";
        private String Token = "";

        public ResumeAd(Context context, String adId, String token){
            appContext = context;
            GPNLib.setDeviceId(appContext);
            Token = token;
            AdId = adId;
        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/resumead";


                final String TOKEN = "token";
                final String AD_ID = "adid";


                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(TOKEN, Token)
                        .appendQueryParameter(AD_ID, AdId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
            super.onPostExecute(jsonObject);

            Activity activity = (Activity) appContext;
            Button mActionButton = (Button) activity.findViewById(R.id.gpn_sdk_offer_detail_button_btnCupom);
            try {
                if (jsonObject.getInt("s") == 200) {
                    mActionButton.setText("Pausar");
                    mActionButton.setOnClickListener(null);
                    mActionButton.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            new PauseAd(appContext, AdId, Token).execute();
                        }
                    });
                } else {
                    Toast.makeText(appContext, "Erro ao pausar campanha", Toast.LENGTH_SHORT).show();
                }
            }catch (JSONException exc){
                Log.e(LOG, exc.toString());
            }
        }

    }

    public static class RegisterLocation extends AsyncTask<String, Void, JSONObject> {

        private final String LOG = "GPN";
        private Context appContext;

        public RegisterLocation(Context context){
            appContext = context;
            GPNLib.setDeviceId(appContext);
        }

        @Override
        protected JSONObject doInBackground(String... params) {

            // These two need to be declared outside the try/catch
            // so that they can be closed in the finally block.
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;

            // Will contain the raw JSON response as a string.
            String jsonStr = null;
            String adId = params[0];

            try {
                final String BASE_URL =
                        "http://backend.geopushnetwork.com/mobile/registerLocation";


                final String DEVICE_ID = "deviceId";
                final String AD_ID = "adid";


                Uri builtUri = Uri.parse(BASE_URL).buildUpon()
                        .appendQueryParameter(DEVICE_ID, deviceId)
                        .appendQueryParameter(AD_ID, adId)
                        .build();

                URL url = new URL(builtUri.toString());

                // Create the request to OpenWeatherMap, and open the connection
                urlConnection = (HttpURLConnection) url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();

                // Read the input stream into a String
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    // Nothing to do.
                    return null;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));

                String line;
                while ((line = reader.readLine()) != null) {
                    // Since it's JSON, adding a newline isn't necessary (it won't affect parsing)
                    // But it does make debugging a *lot* easier if you print out the completed
                    // buffer for debugging.
                    buffer.append(line + "\n");
                }

                if (buffer.length() == 0) {
                    // Stream was empty.  No point in parsing.
                    return null;
                }
                jsonStr = buffer.toString();
                JSONObject jsonObject = new JSONObject(jsonStr);
                return jsonObject;

            } catch (IOException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } catch (JSONException e) {
                Log.e(LOG, "Error ", e);
                // If the code didn't successfully get the weather data, there's no point in attempting
                // to parse it.
            } finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (final IOException e) {
                        Log.e(LOG, "Error closing stream", e);
                    }
                }
            }
            return null;
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final JSONObject jsonObject) {
            super.onPostExecute(jsonObject);
        }

    }



}
