package com.geopushnetwork.sdk;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.qrcode.QRCodeWriter;

public class CupomActivity extends AppCompatActivity {

    private final String LOG = "GPN";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_cupom);
        Intent intent = getIntent();

        ActionBar actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        String code = intent.getStringExtra("CUPOM_CODE");

        TextView cupomCode = (TextView)findViewById(R.id.cupomCode);
        cupomCode.setText(code);
        ImageView qrCode = (ImageView)findViewById(R.id.qrCode);
        qrCode.setImageBitmap(cretaeQRCode(code));
    }

    @Override
    public boolean onSupportNavigateUp(){
        finish();
        return true;
    }

    private Bitmap cretaeQRCode(String text)
    {
        QRCodeWriter writer = new QRCodeWriter();

        try {
            ByteMatrix bitMatrix = writer.encode(text, BarcodeFormat.QR_CODE, 512, 512);

            int width = 512;
            int height = 512;
            Bitmap bmp = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);
            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    if (bitMatrix.get(x, y)==0)
                        bmp.setPixel(x, y, Color.BLACK);
                    else
                        bmp.setPixel(x, y, Color.WHITE);
                }
            }

            return bmp;
        } catch (WriterException e) {
            Log.e(LOG, e.toString());
            return null;
        }
    }
}