/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk.sync;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.ActivityManager;
import android.content.AbstractThreadedSyncAdapter;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SyncRequest;
import android.content.SyncResult;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import com.geopushnetwork.sdk.GPNLib;
import com.geopushnetwork.sdk.IBeaconService;
import com.geopushnetwork.sdk.R;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationServices;

public class GPNSyncAdapter
extends AbstractThreadedSyncAdapter {
    public final String LOG_TAG = "GPN";
    public static final int SYNC_INTERVAL = 180;
    public static final int SYNC_FLEXTIME = 1;
    public static final int SYNC_VERSION = 1;

    public GPNSyncAdapter(Context context, boolean autoInitialize) {
        super(context, autoInitialize);
    }

    public void onPerformSync(Account account, Bundle extras, String authority, ContentProviderClient provider, SyncResult syncResult) {
        Log.d((String)"GPN", (String)"Starting sync");
        final GoogleApiClient mGoogleApiClient = new GoogleApiClient.Builder(this.getContext()).addApi(LocationServices.API).build();
        mGoogleApiClient.registerConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(ConnectionResult connectionResult) {
                Log.e((String)"GPN", (String)("Error connecting to google play services. Error: " + connectionResult.getErrorMessage()));
            }
        });
        mGoogleApiClient.registerConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                Location mLastLocation = LocationServices.FusedLocationApi.getLastLocation(mGoogleApiClient);
                if (mLastLocation == null) {
                    Log.e((String)"GPN", (String)"Location services not enabled.");
                    GPNLib.latitude = 0.0;
                    GPNLib.longitude = 0.0;
                    Toast.makeText((Context)GPNSyncAdapter.this.getContext(), (CharSequence)"Para receber ofertas mais precisas, voc\u00ea deve deixar que o app obtenha a sua localiza\u00e7ao.", (int)1).show();
                } else {
                    GPNLib.latitude = mLastLocation.getLatitude();
                    GPNLib.longitude = mLastLocation.getLongitude();
                }
                new GPNLib.RequestOfferList(GPNSyncAdapter.this.getContext()).execute(new Void[0]);
                if (!GPNSyncAdapter.this.isMyServiceRunning(IBeaconService.class)) {
                    GPNSyncAdapter.this.getContext().startService(new Intent(GPNSyncAdapter.this.getContext(), IBeaconService.class));
                    Log.d((String)"GPN", (String)"Iniciando beacon service");
                }
            }

            public void onConnectionSuspended(int i) {
                Log.e((String)"GPN", (String)("Error connecting to google play was suspended. Error: " + i));
            }
        });
        mGoogleApiClient.connect();
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getContext().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals("com.geopushnetwork.sdk.IBeaconService")) continue;
            return true;
        }
        return false;
    }

    public static void configurePeriodicSync(Context context, int syncInterval, int flexTime) {
        Account account = GPNSyncAdapter.getSyncAccount(context);
        String authority = context.getString(R.string.content_authority_gpn_sdk);
        if (Build.VERSION.SDK_INT >= 19) {
            SyncRequest request = new SyncRequest.Builder().syncPeriodic((long)syncInterval, (long)flexTime).setSyncAdapter(account, authority).setExtras(new Bundle()).build();
            ContentResolver.requestSync((SyncRequest)request);
        } else {
            ContentResolver.addPeriodicSync((Account)account, (String)authority, (Bundle)new Bundle(), (long)syncInterval);
        }
    }

    public static void syncImmediately(Context context) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("expedited", true);
        bundle.putBoolean("force", true);
        ContentResolver.requestSync((Account)GPNSyncAdapter.getSyncAccount(context), (String)context.getString(R.string.content_authority_gpn_sdk), (Bundle)bundle);
    }

    public static Account getSyncAccount(Context context) {
        Account newAccount;
        AccountManager accountManager = (AccountManager)context.getSystemService("account");
        if (null == accountManager.getPassword(newAccount = new Account("GeopushSDK", "geopushnetwork"))) {
            if (!accountManager.addAccountExplicitly(newAccount, "", null)) {
                return null;
            }
            GPNSyncAdapter.onAccountCreated(newAccount, context);
        }
        return newAccount;
    }

    private static void onAccountCreated(Account newAccount, Context context) {
        GPNSyncAdapter.configurePeriodicSync(context, 180, 1);
        ContentResolver.setSyncAutomatically((Account)newAccount, (String)context.getString(R.string.content_authority_gpn_sdk), (boolean)true);
        GPNSyncAdapter.syncImmediately(context);
    }

    public static void initializeSyncAdapter(Context context) {
        GPNSyncAdapter.getSyncAccount(context);
    }
}

