/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import com.estimote.sdk.Beacon;
import com.estimote.sdk.BeaconManager;
import com.estimote.sdk.Region;
import com.geopushnetwork.sdk.GPNLib;
import com.geopushnetwork.sdk.OfferDetail;
import java.util.List;
import java.util.UUID;

public class IBeaconService
extends Service {
    private BeaconManager beaconManager;
    private String LOG = "";

    public void onCreate() {
        super.onCreate();
        this.beaconManager = new BeaconManager(this.getApplicationContext());
        this.beaconManager.connect(new BeaconManager.ServiceReadyCallback(){

            public void onServiceReady() {
                IBeaconService.this.beaconManager.startMonitoring(new Region("monitored region", UUID.fromString("B9407F30-F5F8-466E-AFF9-25556B57FE6D"), null, null));
                IBeaconService.this.beaconManager.setMonitoringListener(new BeaconManager.MonitoringListener(){

                    public void onEnteredRegion(Region region, List<Beacon> list) {
                        String uuid = region.getProximityUUID().toString();
                        String major = String.valueOf(list.get(0).getMajor());
                        String minor = String.valueOf(list.get(0).getMinor());
                        new GPNLib.BeaconSync(IBeaconService.this.getApplicationContext()).execute(new String[]{uuid, major, minor});
                    }

                    public void onExitedRegion(Region region) {
                        IBeaconService.this.showNotification("Saiu", "Saiu");
                    }
                });
            }
        });
    }

    public void showNotification(String title, String message) {
        Intent notifyIntent = new Intent((Context)this, OfferDetail.class);
        notifyIntent.putExtra("ID", "pus-814d68e0-6dcf-11e5-8b45-7f8c1ae46cb0");
        notifyIntent.setFlags(0x20000000);
        PendingIntent pendingIntent = PendingIntent.getActivities((Context)this, (int)0, (Intent[])new Intent[]{notifyIntent}, (int)0x8000000);
        Notification notification = new Notification.Builder((Context)this).setSmallIcon(17301659).setContentTitle((CharSequence)title).setContentText((CharSequence)message).setAutoCancel(true).setContentIntent(pendingIntent).build();
        notification.defaults |= 1;
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        notificationManager.notify(1, notification);
    }

    public IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

