/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.detector;

import com.google.zxing.BlackPointEstimationMethod;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GenericResultPoint;
import com.google.zxing.common.GridSampler;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.detector.AlignmentPattern;
import com.google.zxing.qrcode.detector.AlignmentPatternFinder;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;

public final class Detector {
    private final MonochromeBitmapSource image;

    public Detector(MonochromeBitmapSource image) {
        this.image = image;
    }

    public DetectorResult detect() throws ReaderException {
        return this.detect(null);
    }

    public DetectorResult detect(Hashtable hints) throws ReaderException {
        FinderPattern bottomLeft;
        FinderPattern topRight;
        FinderPatternFinder finder;
        FinderPatternInfo info;
        FinderPattern topLeft;
        float moduleSize;
        MonochromeBitmapSource image = this.image;
        if (!BlackPointEstimationMethod.TWO_D_SAMPLING.equals(image.getLastEstimationMethod())) {
            image.estimateBlackPoint(BlackPointEstimationMethod.TWO_D_SAMPLING, 0);
        }
        if ((moduleSize = this.calculateModuleSize(topLeft = (info = (finder = new FinderPatternFinder(image)).find(hints)).getTopLeft(), topRight = info.getTopRight(), bottomLeft = info.getBottomLeft())) < 1.0f) {
            throw ReaderException.getInstance();
        }
        int dimension = Detector.computeDimension(topLeft, topRight, bottomLeft, moduleSize);
        Version provisionalVersion = Version.getProvisionalVersionForDimension(dimension);
        int modulesBetweenFPCenters = provisionalVersion.getDimensionForVersion() - 7;
        AlignmentPattern alignmentPattern = null;
        if (provisionalVersion.getAlignmentPatternCenters().length > 0) {
            float bottomRightX = topRight.getX() - topLeft.getX() + bottomLeft.getX();
            float bottomRightY = topRight.getY() - topLeft.getY() + bottomLeft.getY();
            float correctionToTopLeft = 1.0f - 3.0f / (float)modulesBetweenFPCenters;
            int estAlignmentX = (int)(topLeft.getX() + correctionToTopLeft * (bottomRightX - topLeft.getX()));
            int estAlignmentY = (int)(topLeft.getY() + correctionToTopLeft * (bottomRightY - topLeft.getY()));
            for (int i = 4; i <= 16; i <<= 1) {
                try {
                    alignmentPattern = this.findAlignmentInRegion(moduleSize, estAlignmentX, estAlignmentY, i);
                    break;
                }
                catch (ReaderException re) {
                    continue;
                }
            }
            if (alignmentPattern == null) {
                throw ReaderException.getInstance();
            }
        }
        BitMatrix bits = Detector.sampleGrid(image, topLeft, topRight, bottomLeft, alignmentPattern, dimension);
        ResultPoint[] points = alignmentPattern == null ? new ResultPoint[]{bottomLeft, topLeft, topRight} : new ResultPoint[]{bottomLeft, topLeft, topRight, alignmentPattern};
        return new DetectorResult(bits, points);
    }

    private static BitMatrix sampleGrid(MonochromeBitmapSource image, ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, ResultPoint alignmentPattern, int dimension) throws ReaderException {
        float sourceBottomRightX;
        float sourceBottomRightY;
        float bottomRightY;
        float bottomRightX;
        float dimMinusThree = (float)dimension - 3.5f;
        if (alignmentPattern != null) {
            bottomRightX = alignmentPattern.getX();
            bottomRightY = alignmentPattern.getY();
            sourceBottomRightX = sourceBottomRightY = dimMinusThree - 3.0f;
        } else {
            bottomRightX = topRight.getX() - topLeft.getX() + bottomLeft.getX();
            bottomRightY = topRight.getY() - topLeft.getY() + bottomLeft.getY();
            sourceBottomRightX = sourceBottomRightY = dimMinusThree;
        }
        GridSampler sampler = GridSampler.getInstance();
        return sampler.sampleGrid(image, dimension, 3.5f, 3.5f, dimMinusThree, 3.5f, sourceBottomRightX, sourceBottomRightY, 3.5f, dimMinusThree, topLeft.getX(), topLeft.getY(), topRight.getX(), topRight.getY(), bottomRightX, bottomRightY, bottomLeft.getX(), bottomLeft.getY());
    }

    private static int computeDimension(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft, float moduleSize) throws ReaderException {
        int tltrCentersDimension = Detector.round(GenericResultPoint.distance(topLeft, topRight) / moduleSize);
        int tlblCentersDimension = Detector.round(GenericResultPoint.distance(topLeft, bottomLeft) / moduleSize);
        int dimension = (tltrCentersDimension + tlblCentersDimension >> 1) + 7;
        switch (dimension & 3) {
            case 0: {
                ++dimension;
                break;
            }
            case 2: {
                --dimension;
                break;
            }
            case 3: {
                throw ReaderException.getInstance();
            }
        }
        return dimension;
    }

    private float calculateModuleSize(ResultPoint topLeft, ResultPoint topRight, ResultPoint bottomLeft) {
        return (this.calculateModuleSizeOneWay(topLeft, topRight) + this.calculateModuleSizeOneWay(topLeft, bottomLeft)) / 2.0f;
    }

    private float calculateModuleSizeOneWay(ResultPoint pattern, ResultPoint otherPattern) {
        float moduleSizeEst1 = this.sizeOfBlackWhiteBlackRunBothWays((int)pattern.getX(), (int)pattern.getY(), (int)otherPattern.getX(), (int)otherPattern.getY());
        float moduleSizeEst2 = this.sizeOfBlackWhiteBlackRunBothWays((int)otherPattern.getX(), (int)otherPattern.getY(), (int)pattern.getX(), (int)pattern.getY());
        if (Float.isNaN(moduleSizeEst1)) {
            return moduleSizeEst2;
        }
        if (Float.isNaN(moduleSizeEst2)) {
            return moduleSizeEst1;
        }
        return (moduleSizeEst1 + moduleSizeEst2) / 14.0f;
    }

    private float sizeOfBlackWhiteBlackRunBothWays(int fromX, int fromY, int toX, int toY) {
        float result = this.sizeOfBlackWhiteBlackRun(fromX, fromY, toX, toY);
        int otherToX = fromX - (toX - fromX);
        if (otherToX < 0) {
            otherToX = -1;
        } else if (otherToX >= this.image.getWidth()) {
            otherToX = this.image.getWidth();
        }
        int otherToY = fromY - (toY - fromY);
        if (otherToY < 0) {
            otherToY = -1;
        } else if (otherToY >= this.image.getHeight()) {
            otherToY = this.image.getHeight();
        }
        return (result += this.sizeOfBlackWhiteBlackRun(fromX, fromY, otherToX, otherToY)) - 1.0f;
    }

    private float sizeOfBlackWhiteBlackRun(int fromX, int fromY, int toX, int toY) {
        boolean steep;
        boolean bl = steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx >> 1;
        int ystep = fromY < toY ? 1 : -1;
        int xstep = fromX < toX ? 1 : -1;
        int state = 0;
        int y = fromY;
        for (int x = fromX; x != toX; x += xstep) {
            int realY;
            int realX = steep ? y : x;
            int n = realY = steep ? x : y;
            if (state == 1) {
                if (this.image.isBlack(realX, realY)) {
                    ++state;
                }
            } else if (!this.image.isBlack(realX, realY)) {
                ++state;
            }
            if (state == 3) {
                int diffX = x - fromX;
                int diffY = y - fromY;
                return (float)Math.sqrt(diffX * diffX + diffY * diffY);
            }
            if ((error += dy) <= 0) continue;
            y += ystep;
            error -= dx;
        }
        int diffX = toX - fromX;
        int diffY = toY - fromY;
        return (float)Math.sqrt(diffX * diffX + diffY * diffY);
    }

    private AlignmentPattern findAlignmentInRegion(float overallEstModuleSize, int estAlignmentX, int estAlignmentY, float allowanceFactor) throws ReaderException {
        int allowance = (int)(allowanceFactor * overallEstModuleSize);
        int alignmentAreaLeftX = Math.max(0, estAlignmentX - allowance);
        int alignmentAreaRightX = Math.min(this.image.getWidth() - 1, estAlignmentX + allowance);
        if ((float)(alignmentAreaRightX - alignmentAreaLeftX) < overallEstModuleSize * 3.0f) {
            throw ReaderException.getInstance();
        }
        int alignmentAreaTopY = Math.max(0, estAlignmentY - allowance);
        int alignmentAreaBottomY = Math.min(this.image.getHeight() - 1, estAlignmentY + allowance);
        AlignmentPatternFinder alignmentFinder = new AlignmentPatternFinder(this.image, alignmentAreaLeftX, alignmentAreaTopY, alignmentAreaRightX - alignmentAreaLeftX, alignmentAreaBottomY - alignmentAreaTopY, overallEstModuleSize);
        return alignmentFinder.find();
    }

    private static int round(float d) {
        return (int)(d + 0.5f);
    }
}

