/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS = new DataMask[]{new DataMask000(), new DataMask001(), new DataMask010(), new DataMask011(), new DataMask100(), new DataMask101(), new DataMask110(), new DataMask111()};

    private DataMask() {
    }

    abstract void unmaskBitMatrix(int[] var1, int var2);

    static DataMask forReference(int reference) {
        if (reference < 0 || reference > 7) {
            throw new IllegalArgumentException();
        }
        return DATA_MASKS[reference];
    }

    private static class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                for (int i = 0; i < dimension; ++i) {
                    if (((i + j & 1) + i * j % 3 & 1) == 0) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                for (int i = 0; i < dimension; ++i) {
                    int product = i * j;
                    if (((product & 1) + product % 3 & 1) == 0) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                for (int i = 0; i < dimension; ++i) {
                    int product = i * j;
                    if ((product & 1) == 0 && product % 3 == 0) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                int jComponentParity = j / 3 & 1;
                for (int i = 0; i < dimension; ++i) {
                    if ((i >> 1 & 1) == jComponentParity) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                for (int i = 0; i < dimension; ++i) {
                    if ((i + j) % 3 == 0) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                boolean columnMasked = j % 3 == 0;
                for (int i = 0; i < dimension; ++i) {
                    if (columnMasked) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int bitMask = 0;
            int count = 0;
            int offset = 0;
            for (int j = 0; j < dimension; ++j) {
                for (int i = 0; i < dimension; ++i) {
                    if ((i & 1) == 0) {
                        bitMask |= 1 << count;
                    }
                    if (++count != 32) continue;
                    int n = offset++;
                    bits[n] = bits[n] ^ bitMask;
                    count = 0;
                    bitMask = 0;
                }
            }
            int n = offset;
            bits[n] = bits[n] ^ bitMask;
        }
    }

    private static class DataMask000
    extends DataMask {
        private static final int BITMASK = 0x55555555;

        private DataMask000() {
        }

        void unmaskBitMatrix(int[] bits, int dimension) {
            int max = bits.length;
            int i = 0;
            while (i < max) {
                int n = i++;
                bits[n] = bits[n] ^ 0x55555555;
            }
        }
    }
}

