/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import java.util.Hashtable;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    public ByteMatrix encode(String contents, BarcodeFormat format, int width, int height) throws WriterException {
        return this.encode(contents, format, width, height, null);
    }

    public ByteMatrix encode(String contents, BarcodeFormat format, int width, int height, Hashtable hints) throws WriterException {
        ErrorCorrectionLevel requestedECLevel;
        if (contents == null || contents.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (format != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + format);
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + width + 'x' + height);
        }
        ErrorCorrectionLevel errorCorrectionLevel = ErrorCorrectionLevel.L;
        if (hints != null && (requestedECLevel = (ErrorCorrectionLevel)hints.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            errorCorrectionLevel = requestedECLevel;
        }
        QRCode code = new QRCode();
        Encoder.encode(contents, errorCorrectionLevel, code);
        return QRCodeWriter.renderResult(code, width, height);
    }

    private static ByteMatrix renderResult(QRCode code, int width, int height) {
        int offset;
        ByteMatrix input = code.getMatrix();
        int inputWidth = input.width();
        int inputHeight = input.height();
        int qrWidth = inputWidth + 8;
        int qrHeight = inputHeight + 8;
        int outputWidth = Math.max(width, qrWidth);
        int outputHeight = Math.max(height, qrHeight);
        int multiple = Math.min(outputWidth / qrWidth, outputHeight / qrHeight);
        int leftPadding = (outputWidth - inputWidth * multiple) / 2;
        int topPadding = (outputHeight - inputHeight * multiple) / 2;
        ByteMatrix output = new ByteMatrix(outputHeight, outputWidth);
        byte[][] outputArray = output.getArray();
        byte[] row = new byte[outputWidth];
        for (int y = 0; y < topPadding; ++y) {
            QRCodeWriter.setRowColor(outputArray[y], (byte)-1);
        }
        byte[][] inputArray = input.getArray();
        for (int y = 0; y < inputHeight; ++y) {
            int x;
            for (int x2 = 0; x2 < leftPadding; ++x2) {
                row[x2] = -1;
            }
            int offset2 = leftPadding;
            for (x = 0; x < inputWidth; ++x) {
                int value = inputArray[y][x] == 1 ? 0 : -1;
                for (int z = 0; z < multiple; ++z) {
                    row[offset2 + z] = value;
                }
                offset2 += multiple;
            }
            for (x = offset2 = leftPadding + inputWidth * multiple; x < outputWidth; ++x) {
                row[x] = -1;
            }
            offset2 = topPadding + y * multiple;
            for (int z = 0; z < multiple; ++z) {
                System.arraycopy(row, 0, outputArray[offset2 + z], 0, outputWidth);
            }
        }
        for (int y = offset = topPadding + inputHeight * multiple; y < outputHeight; ++y) {
            QRCodeWriter.setRowColor(outputArray[y], (byte)-1);
        }
        return output;
    }

    private static void setRowColor(byte[] row, byte value) {
        for (int x = 0; x < row.length; ++x) {
            row[x] = value;
        }
    }
}

