/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.detector.Detector;
import java.util.Hashtable;

public final class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    public Result decode(MonochromeBitmapSource image) throws ReaderException {
        return this.decode(image, null);
    }

    public Result decode(MonochromeBitmapSource image, Hashtable hints) throws ReaderException {
        ResultPoint[] points;
        DecoderResult decoderResult;
        if (hints != null && hints.containsKey(DecodeHintType.PURE_BARCODE)) {
            BitMatrix bits = QRCodeReader.extractPureBits(image);
            decoderResult = this.decoder.decode(bits);
            points = NO_POINTS;
        } else {
            DetectorResult detectorResult = new Detector(image).detect(hints);
            decoderResult = this.decoder.decode(detectorResult.getBits());
            points = detectorResult.getPoints();
        }
        Result result = new Result(decoderResult.getText(), decoderResult.getRawBytes(), points, BarcodeFormat.QR_CODE);
        if (decoderResult.getByteSegments() != null) {
            result.putMetadata(ResultMetadataType.BYTE_SEGMENTS, decoderResult.getByteSegments());
        }
        return result;
    }

    private static BitMatrix extractPureBits(MonochromeBitmapSource image) throws ReaderException {
        int dimension;
        int sampleDimension;
        int rowEndOfSymbol;
        int moduleEnd;
        int borderWidth;
        int height = image.getHeight();
        int width = image.getWidth();
        int minDimension = Math.min(height, width);
        for (borderWidth = 0; borderWidth < minDimension && !image.isBlack(borderWidth, borderWidth); ++borderWidth) {
        }
        if (borderWidth == minDimension) {
            throw ReaderException.getInstance();
        }
        for (moduleEnd = borderWidth; moduleEnd < minDimension && image.isBlack(moduleEnd, moduleEnd); ++moduleEnd) {
        }
        if (moduleEnd == minDimension) {
            throw ReaderException.getInstance();
        }
        int moduleSize = moduleEnd - borderWidth;
        for (rowEndOfSymbol = width - 1; rowEndOfSymbol >= 0 && !image.isBlack(rowEndOfSymbol, borderWidth); --rowEndOfSymbol) {
        }
        if (rowEndOfSymbol < 0) {
            throw ReaderException.getInstance();
        }
        if ((++rowEndOfSymbol - borderWidth) % moduleSize != 0) {
            throw ReaderException.getInstance();
        }
        if ((sampleDimension = (borderWidth += moduleSize >> 1) + ((dimension = (rowEndOfSymbol - borderWidth) / moduleSize) - 1) * moduleSize) >= width || sampleDimension >= height) {
            throw ReaderException.getInstance();
        }
        BitMatrix bits = new BitMatrix(dimension);
        for (int i = 0; i < dimension; ++i) {
            int iOffset = borderWidth + i * moduleSize;
            for (int j = 0; j < dimension; ++j) {
                if (!image.isBlack(borderWidth + j * moduleSize, iOffset)) continue;
                bits.set(i, j);
            }
        }
        return bits;
    }
}

