/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BlackPointEstimationMethod;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.GenericResultPoint;
import com.google.zxing.oned.OneDReader;
import java.util.Hashtable;

public abstract class AbstractOneDReader
implements OneDReader {
    private static final int INTEGER_MATH_SHIFT = 8;
    static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;

    public final Result decode(MonochromeBitmapSource image) throws ReaderException {
        return this.decode(image, null);
    }

    public final Result decode(MonochromeBitmapSource image, Hashtable hints) throws ReaderException {
        try {
            return this.doDecode(image, hints);
        }
        catch (ReaderException re) {
            boolean tryHarder;
            boolean bl = tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
            if (tryHarder && image.isRotateSupported()) {
                MonochromeBitmapSource rotatedImage = image.rotateCounterClockwise();
                Result result = this.doDecode(rotatedImage, hints);
                Hashtable metadata = result.getResultMetadata();
                int orientation = 270;
                if (metadata != null && metadata.containsKey(ResultMetadataType.ORIENTATION)) {
                    orientation = (orientation + (Integer)metadata.get(ResultMetadataType.ORIENTATION)) % 360;
                }
                result.putMetadata(ResultMetadataType.ORIENTATION, new Integer(orientation));
                return result;
            }
            throw re;
        }
    }

    private Result doDecode(MonochromeBitmapSource image, Hashtable hints) throws ReaderException {
        int width = image.getWidth();
        int height = image.getHeight();
        BitArray row = new BitArray(width);
        int middle = height >> 1;
        boolean tryHarder = hints != null && hints.containsKey(DecodeHintType.TRY_HARDER);
        int rowStep = Math.max(1, height >> (tryHarder ? 7 : 4));
        int maxLines = tryHarder ? height : 9;
        for (int x = 0; x < maxLines; ++x) {
            int rowStepsAboveOrBelow = x + 1 >> 1;
            boolean isAbove = (x & 1) == 0;
            int rowNumber = middle + rowStep * (isAbove ? rowStepsAboveOrBelow : -rowStepsAboveOrBelow);
            if (rowNumber < 0 || rowNumber >= height) break;
            try {
                image.estimateBlackPoint(BlackPointEstimationMethod.ROW_SAMPLING, rowNumber);
            }
            catch (ReaderException re) {
                continue;
            }
            image.getBlackRow(rowNumber, row, 0, width);
            for (int attempt = 0; attempt < 2; ++attempt) {
                if (attempt == 1) {
                    row.reverse();
                }
                try {
                    Result result = this.decodeRow(rowNumber, row, hints);
                    if (attempt == 1) {
                        result.putMetadata(ResultMetadataType.ORIENTATION, new Integer(180));
                        ResultPoint[] points = result.getResultPoints();
                        points[0] = new GenericResultPoint((float)width - points[0].getX() - 1.0f, points[0].getY());
                        points[1] = new GenericResultPoint((float)width - points[1].getX() - 1.0f, points[1].getY());
                    }
                    return result;
                }
                catch (ReaderException re) {
                    continue;
                }
            }
        }
        throw ReaderException.getInstance();
    }

    static void recordPattern(BitArray row, int start, int[] counters) throws ReaderException {
        int i;
        int numCounters = counters.length;
        for (int i2 = 0; i2 < numCounters; ++i2) {
            counters[i2] = 0;
        }
        int end = row.getSize();
        if (start >= end) {
            throw ReaderException.getInstance();
        }
        boolean isWhite = !row.get(start);
        int counterPosition = 0;
        for (i = start; i < end; ++i) {
            boolean pixel = row.get(i);
            if (pixel ^ isWhite) {
                int n = counterPosition;
                counters[n] = counters[n] + 1;
                continue;
            }
            if (++counterPosition == numCounters) break;
            counters[counterPosition] = 1;
            isWhite ^= true;
        }
        if (counterPosition != numCounters && (counterPosition != numCounters - 1 || i != end)) {
            throw ReaderException.getInstance();
        }
    }

    static int patternMatchVariance(int[] counters, int[] pattern, int maxIndividualVariance) {
        int numCounters = counters.length;
        int total = 0;
        int patternLength = 0;
        for (int i = 0; i < numCounters; ++i) {
            total += counters[i];
            patternLength += pattern[i];
        }
        if (total < patternLength) {
            return Integer.MAX_VALUE;
        }
        int unitBarWidth = (total << 8) / patternLength;
        maxIndividualVariance = maxIndividualVariance * unitBarWidth >> 8;
        int totalVariance = 0;
        for (int x = 0; x < numCounters; ++x) {
            int variance;
            int counter = counters[x] << 8;
            int scaledPattern = pattern[x] * unitBarWidth;
            int n = variance = counter > scaledPattern ? counter - scaledPattern : scaledPattern - counter;
            if (variance > maxIndividualVariance) {
                return Integer.MAX_VALUE;
            }
            totalVariance += variance;
        }
        return totalVariance / total;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Hashtable var3) throws ReaderException;
}

