/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int height;
    private final int width;

    public ByteMatrix(int height, int width) {
        this.bytes = new byte[height][width];
        this.height = height;
        this.width = width;
    }

    public int height() {
        return this.height;
    }

    public int width() {
        return this.width;
    }

    public byte get(int y, int x) {
        return this.bytes[y][x];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int y, int x, byte value) {
        this.bytes[y][x] = value;
    }

    public void set(int y, int x, int value) {
        this.bytes[y][x] = (byte)value;
    }

    public void clear(byte value) {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.bytes[y][x] = value;
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        for (int y = 0; y < this.height; ++y) {
            block5: for (int x = 0; x < this.width; ++x) {
                switch (this.bytes[y][x]) {
                    case 0: {
                        result.append(" 0");
                        continue block5;
                    }
                    case 1: {
                        result.append(" 1");
                        continue block5;
                    }
                    default: {
                        result.append("  ");
                    }
                }
            }
            result.append('\n');
        }
        return result.toString();
    }
}

