/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.util.Hashtable;

public final class Result {
    private final String text;
    private final byte[] rawBytes;
    private final ResultPoint[] resultPoints;
    private final BarcodeFormat format;
    private Hashtable resultMetadata;

    public Result(String text, byte[] rawBytes, ResultPoint[] resultPoints, BarcodeFormat format) {
        if (text == null && rawBytes == null) {
            throw new IllegalArgumentException("Text and bytes are null");
        }
        this.text = text;
        this.rawBytes = rawBytes;
        this.resultPoints = resultPoints;
        this.format = format;
        this.resultMetadata = null;
    }

    public String getText() {
        return this.text;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public ResultPoint[] getResultPoints() {
        return this.resultPoints;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.format;
    }

    public Hashtable getResultMetadata() {
        return this.resultMetadata;
    }

    public void putMetadata(ResultMetadataType type, Object value) {
        if (this.resultMetadata == null) {
            this.resultMetadata = new Hashtable(3);
        }
        this.resultMetadata.put(type, value);
    }

    public String toString() {
        if (this.text == null) {
            return "[" + this.rawBytes.length + " bytes]";
        }
        return this.text;
    }
}

