package com.geopushnetwork.sdk;

import android.app.Activity;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.ArrayAdapter;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.view.LayoutInflater;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.lang.ref.WeakReference;

import java.util.ArrayList;

public class CupomAdapter extends ArrayAdapter<Cupom> {

    private final Context Context;
    private final ArrayList<Cupom> Values;
    private static View rowView;


    public CupomAdapter(Context context, ArrayList<Cupom> values) {
        super(context, -1, values);
        Context = context;
        Values = values;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        LayoutInflater inflater = (LayoutInflater) Context
                .getSystemService(Context.LAYOUT_INFLATER_SERVICE);
        rowView = inflater.inflate(R.layout.cupom_list_item, parent, false);

        TextView offerText = (TextView) rowView.findViewById(R.id.cupomCode);
        offerText.setText((Values.get(position).code));

        TextView advertiserName = (TextView) rowView.findViewById(R.id.cupomDescription);
        advertiserName.setText((Values.get(position).title));

        return rowView;
    }

    public static class SetImageInBackground extends AsyncTask<String, Void, BitmapDrawable> {

        private final WeakReference<RelativeLayout> imageViewReference;

        public SetImageInBackground(RelativeLayout imageView) {
            imageViewReference = new WeakReference<RelativeLayout>(imageView);
        }


        @Override
        protected BitmapDrawable doInBackground(String... params) {

            final String url = params[0];

            //se nao estiver presente no cache faz download
            //setando a imagem
            try {
                BitmapDrawable bitmapDrawable = new BitmapDrawable(BitmapFactory.decodeStream(
                        new URL(url).openStream()));
                return bitmapDrawable;
            } catch (MalformedURLException exc){
                Log.e("OffyGourmet", exc.toString());
            } catch (IOException exc){
                Log.e("OffyGourmet", exc.toString());
            }

            return null;

        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(final BitmapDrawable img) {

            if (imageViewReference != null) {
                RelativeLayout imageView = imageViewReference.get();
                if (imageView != null) {
                    if (img != null) {
                        imageView.setBackground(img);
                    }
                }
            }

        }

    }
}
