/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

public final class UPCAReader
implements UPCEANReader {
    private final UPCEANReader ean13Reader = new EAN13Reader();

    public Result decodeRow(int rowNumber, BitArray row, int[] startGuardRange) throws ReaderException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row, startGuardRange));
    }

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws ReaderException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decodeRow(rowNumber, row, hints));
    }

    public Result decode(MonochromeBitmapSource image) throws ReaderException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image));
    }

    public Result decode(MonochromeBitmapSource image, Hashtable hints) throws ReaderException {
        return UPCAReader.maybeReturnResult(this.ean13Reader.decode(image, hints));
    }

    private static Result maybeReturnResult(Result result) throws ReaderException {
        String text = result.getText();
        if (text.charAt(0) == '0') {
            return new Result(text.substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
        }
        throw ReaderException.getInstance();
    }
}

