/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.AbstractOneDReader;
import com.google.zxing.oned.AbstractUPCEANReader;
import com.google.zxing.oned.EAN13Reader;
import com.google.zxing.oned.EAN8Reader;
import com.google.zxing.oned.UPCAReader;
import com.google.zxing.oned.UPCEANReader;
import com.google.zxing.oned.UPCEReader;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiFormatUPCEANReader
extends AbstractOneDReader {
    private final Vector readers;

    public MultiFormatUPCEANReader(Hashtable hints) {
        Vector possibleFormats = hints == null ? null : (Vector)hints.get(DecodeHintType.POSSIBLE_FORMATS);
        this.readers = new Vector();
        if (possibleFormats != null) {
            if (possibleFormats.contains(BarcodeFormat.EAN_13)) {
                this.readers.addElement(new EAN13Reader());
            } else if (possibleFormats.contains(BarcodeFormat.UPC_A)) {
                this.readers.addElement(new UPCAReader());
            }
            if (possibleFormats.contains(BarcodeFormat.EAN_8)) {
                this.readers.addElement(new EAN8Reader());
            }
            if (possibleFormats.contains(BarcodeFormat.UPC_E)) {
                this.readers.addElement(new UPCEReader());
            }
        }
        if (this.readers.isEmpty()) {
            this.readers.addElement(new EAN13Reader());
            this.readers.addElement(new EAN8Reader());
            this.readers.addElement(new UPCEReader());
        }
    }

    public Result decodeRow(int rowNumber, BitArray row, Hashtable hints) throws ReaderException {
        int[] startGuardPattern = AbstractUPCEANReader.findStartGuardPattern(row);
        int size = this.readers.size();
        for (int i = 0; i < size; ++i) {
            Result result;
            UPCEANReader reader = (UPCEANReader)this.readers.elementAt(i);
            try {
                result = reader.decodeRow(rowNumber, row, startGuardPattern);
            }
            catch (ReaderException re) {
                continue;
            }
            if (result.getBarcodeFormat().equals(BarcodeFormat.EAN_13) && result.getText().charAt(0) == '0') {
                return new Result(result.getText().substring(1), null, result.getResultPoints(), BarcodeFormat.UPC_A);
            }
            return result;
        }
        throw ReaderException.getInstance();
    }
}

