/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.detector;

import com.google.zxing.MonochromeBitmapSource;
import com.google.zxing.ReaderException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.Collections;
import com.google.zxing.common.Comparator;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.common.GenericResultPoint;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MonochromeRectangleDetector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Detector {
    private static final int MAX_MODULES = 32;
    private static final Integer[] INTEGERS = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4)};
    private final MonochromeBitmapSource image;
    private final MonochromeRectangleDetector rectangleDetector;

    public Detector(MonochromeBitmapSource image) {
        this.image = image;
        this.rectangleDetector = new MonochromeRectangleDetector(image);
    }

    public DetectorResult detect() throws ReaderException {
        ResultPoint[] cornerPoints = this.rectangleDetector.detect();
        ResultPoint pointA = cornerPoints[0];
        ResultPoint pointB = cornerPoints[1];
        ResultPoint pointC = cornerPoints[2];
        ResultPoint pointD = cornerPoints[3];
        Vector<ResultPointsAndTransitions> transitions = new Vector<ResultPointsAndTransitions>(4);
        transitions.addElement(this.transitionsBetween(pointA, pointB));
        transitions.addElement(this.transitionsBetween(pointA, pointC));
        transitions.addElement(this.transitionsBetween(pointB, pointD));
        transitions.addElement(this.transitionsBetween(pointC, pointD));
        Collections.insertionSort(transitions, new ResultPointsAndTransitionsComparator());
        ResultPointsAndTransitions lSideOne = (ResultPointsAndTransitions)transitions.elementAt(0);
        ResultPointsAndTransitions lSideTwo = (ResultPointsAndTransitions)transitions.elementAt(1);
        Hashtable pointCount = new Hashtable();
        Detector.increment(pointCount, lSideOne.getFrom());
        Detector.increment(pointCount, lSideOne.getTo());
        Detector.increment(pointCount, lSideTwo.getFrom());
        Detector.increment(pointCount, lSideTwo.getTo());
        ResultPoint maybeTopLeft = null;
        ResultPoint bottomLeft = null;
        ResultPoint maybeBottomRight = null;
        Enumeration points = pointCount.keys();
        while (points.hasMoreElements()) {
            ResultPoint point = (ResultPoint)points.nextElement();
            Integer value = (Integer)pointCount.get(point);
            if (value == 2) {
                bottomLeft = point;
                continue;
            }
            if (maybeTopLeft == null) {
                maybeTopLeft = point;
                continue;
            }
            maybeBottomRight = point;
        }
        if (maybeTopLeft == null || bottomLeft == null || maybeBottomRight == null) {
            throw ReaderException.getInstance();
        }
        ResultPoint[] corners = new ResultPoint[]{maybeTopLeft, bottomLeft, maybeBottomRight};
        GenericResultPoint.orderBestPatterns(corners);
        ResultPoint bottomRight = corners[0];
        bottomLeft = corners[1];
        ResultPoint topLeft = corners[2];
        ResultPoint topRight = !pointCount.containsKey(pointA) ? pointA : (!pointCount.containsKey(pointB) ? pointB : (!pointCount.containsKey(pointC) ? pointC : pointD));
        int dimension = GenericResultPoint.crossProductZ(bottomLeft, bottomRight, topRight) < GenericResultPoint.crossProductZ(topRight, topLeft, bottomLeft) ? this.transitionsBetween(topLeft, topRight).getTransitions() : this.transitionsBetween(bottomRight, topRight).getTransitions();
        BitMatrix bits = Detector.sampleGrid(this.image, topLeft, bottomLeft, bottomRight, dimension += 2);
        return new DetectorResult(bits, new ResultPoint[]{pointA, pointB, pointC, pointD});
    }

    private static void increment(Hashtable table, ResultPoint key) {
        Integer value = (Integer)table.get(key);
        table.put(key, value == null ? INTEGERS[1] : INTEGERS[value + 1]);
    }

    private static BitMatrix sampleGrid(MonochromeBitmapSource image, ResultPoint topLeft, ResultPoint bottomLeft, ResultPoint bottomRight, int dimension) throws ReaderException {
        float topRightX = bottomRight.getX() - bottomLeft.getX() + topLeft.getX();
        float topRightY = bottomRight.getY() - bottomLeft.getY() + topLeft.getY();
        GridSampler sampler = GridSampler.getInstance();
        return sampler.sampleGrid(image, dimension, 0.0f, 0.0f, dimension, 0.0f, dimension, dimension, 0.0f, dimension, topLeft.getX(), topLeft.getY(), topRightX, topRightY, bottomRight.getX(), bottomRight.getY(), bottomLeft.getX(), bottomLeft.getY());
    }

    private ResultPointsAndTransitions transitionsBetween(ResultPoint from, ResultPoint to) {
        boolean steep;
        int fromX = (int)from.getX();
        int fromY = (int)from.getY();
        int toX = (int)to.getX();
        int toY = (int)to.getY();
        boolean bl = steep = Math.abs(toY - fromY) > Math.abs(toX - fromX);
        if (steep) {
            int temp = fromX;
            fromX = fromY;
            fromY = temp;
            temp = toX;
            toX = toY;
            toY = temp;
        }
        int dx = Math.abs(toX - fromX);
        int dy = Math.abs(toY - fromY);
        int error = -dx >> 1;
        int ystep = fromY < toY ? 1 : -1;
        int xstep = fromX < toX ? 1 : -1;
        int transitions = 0;
        boolean inBlack = this.image.isBlack(steep ? fromY : fromX, steep ? fromX : fromY);
        int y = fromY;
        for (int x = fromX; x != toX; x += xstep) {
            boolean isBlack = this.image.isBlack(steep ? y : x, steep ? x : y);
            if (isBlack != inBlack) {
                ++transitions;
                inBlack = isBlack;
            }
            if ((error += dy) <= 0) continue;
            y += ystep;
            error -= dx;
        }
        return new ResultPointsAndTransitions(from, to, transitions);
    }

    private static class ResultPointsAndTransitionsComparator
    implements Comparator {
        private ResultPointsAndTransitionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((ResultPointsAndTransitions)o1).getTransitions() - ((ResultPointsAndTransitions)o2).getTransitions();
        }
    }

    private static class ResultPointsAndTransitions {
        private final ResultPoint from;
        private final ResultPoint to;
        private final int transitions;

        private ResultPointsAndTransitions(ResultPoint from, ResultPoint to, int transitions) {
            this.from = from;
            this.to = to;
            this.transitions = transitions;
        }

        public ResultPoint getFrom() {
            return this.from;
        }

        public ResultPoint getTo() {
            return this.to;
        }

        public int getTransitions() {
            return this.transitions;
        }

        public String toString() {
            return this.from + "/" + this.to + '/' + this.transitions;
        }
    }
}

