/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.ResultPoint;

public final class GenericResultPoint
implements ResultPoint {
    private final float posX;
    private final float posY;

    public GenericResultPoint(float posX, float posY) {
        this.posX = posX;
        this.posY = posY;
    }

    public float getX() {
        return this.posX;
    }

    public float getY() {
        return this.posY;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(25);
        result.append('(');
        result.append(this.posX);
        result.append(',');
        result.append(this.posY);
        result.append(')');
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof GenericResultPoint) {
            GenericResultPoint otherPoint = (GenericResultPoint)other;
            return this.posX == otherPoint.posX && this.posY == otherPoint.posY;
        }
        return false;
    }

    public int hashCode() {
        return 31 * Float.floatToIntBits(this.posX) + Float.floatToIntBits(this.posY);
    }

    public static void orderBestPatterns(ResultPoint[] patterns) {
        ResultPoint pointC;
        ResultPoint pointA;
        ResultPoint pointB;
        float zeroOneDistance = GenericResultPoint.distance(patterns[0], patterns[1]);
        float oneTwoDistance = GenericResultPoint.distance(patterns[1], patterns[2]);
        float zeroTwoDistance = GenericResultPoint.distance(patterns[0], patterns[2]);
        if (oneTwoDistance >= zeroOneDistance && oneTwoDistance >= zeroTwoDistance) {
            pointB = patterns[0];
            pointA = patterns[1];
            pointC = patterns[2];
        } else if (zeroTwoDistance >= oneTwoDistance && zeroTwoDistance >= zeroOneDistance) {
            pointB = patterns[1];
            pointA = patterns[0];
            pointC = patterns[2];
        } else {
            pointB = patterns[2];
            pointA = patterns[0];
            pointC = patterns[1];
        }
        if (GenericResultPoint.crossProductZ(pointA, pointB, pointC) < 0.0f) {
            ResultPoint temp = pointA;
            pointA = pointC;
            pointC = temp;
        }
        patterns[0] = pointA;
        patterns[1] = pointB;
        patterns[2] = pointC;
    }

    public static float distance(ResultPoint pattern1, ResultPoint pattern2) {
        float xDiff = pattern1.getX() - pattern2.getX();
        float yDiff = pattern1.getY() - pattern2.getY();
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public static float crossProductZ(ResultPoint pointA, ResultPoint pointB, ResultPoint pointC) {
        float bX = pointB.getX();
        float bY = pointB.getY();
        return (pointC.getX() - bX) * (pointA.getY() - bY) - (pointC.getY() - bY) * (pointA.getX() - bX);
    }
}

