/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitMatrix {
    private final int dimension;
    private final int[] bits;

    public BitMatrix(int dimension) {
        if (dimension < 1) {
            throw new IllegalArgumentException("dimension must be at least 1");
        }
        this.dimension = dimension;
        int numBits = dimension * dimension;
        int arraySize = numBits >> 5;
        if ((numBits & 0x1F) != 0) {
            ++arraySize;
        }
        this.bits = new int[arraySize];
    }

    public boolean get(int i, int j) {
        int offset = i + this.dimension * j;
        return (this.bits[offset >> 5] >>> (offset & 0x1F) & 1) != 0;
    }

    public void set(int i, int j) {
        int offset = i + this.dimension * j;
        int n = offset >> 5;
        this.bits[n] = this.bits[n] | 1 << (offset & 0x1F);
    }

    public void setRegion(int topI, int leftJ, int height, int width) {
        if (topI < 0 || leftJ < 0) {
            throw new IllegalArgumentException("topI and leftJ must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("height and width must be at least 1");
        }
        int maxJ = leftJ + width;
        int maxI = topI + height;
        if (maxI > this.dimension || maxJ > this.dimension) {
            throw new IllegalArgumentException("topI + height and leftJ + width must be <= matrix dimension");
        }
        for (int j = leftJ; j < maxJ; ++j) {
            int jOffset = this.dimension * j;
            for (int i = topI; i < maxI; ++i) {
                int offset = i + jOffset;
                int n = offset >> 5;
                this.bits[n] = this.bits[n] | 1 << (offset & 0x1F);
            }
        }
    }

    public int getDimension() {
        return this.dimension;
    }

    public int[] getBits() {
        return this.bits;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.dimension * (this.dimension + 1));
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                result.append(this.get(i, j) ? "X " : "  ");
            }
            result.append('\n');
        }
        return result.toString();
    }
}

