/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result.optional;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.google.zxing.client.result.optional.AbstractMobileTagResultParser;
import com.google.zxing.client.result.optional.MobileTagRichWebParsedResult;

final class MobileTagRichWebResultParser
extends AbstractMobileTagResultParser {
    public static final String SERVICE_TYPE = "54";
    private static final int DEFAULT_ACTION = 1;

    MobileTagRichWebResultParser() {
    }

    public static MobileTagRichWebParsedResult parse(Result result) {
        String id;
        int action;
        if (MobileTagRichWebParsedResult.TAGSERVER_URI_PREFIX == null) {
            return null;
        }
        if (!result.getBarcodeFormat().equals(BarcodeFormat.DATAMATRIX)) {
            return null;
        }
        String rawText = result.getText();
        if (!rawText.startsWith(SERVICE_TYPE)) {
            return null;
        }
        int length = rawText.length();
        if (!MobileTagRichWebResultParser.isDigits(rawText, length)) {
            return null;
        }
        if (length == 15) {
            action = 1;
            id = rawText.substring(0, 2) + action + rawText.substring(2);
        } else if (length == 16) {
            action = rawText.charAt(2) - 48;
            id = rawText;
        } else {
            return null;
        }
        return new MobileTagRichWebParsedResult(id, action);
    }
}

