/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk.data;

import android.annotation.TargetApi;
import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import com.geopushnetwork.sdk.data.SDKDataContract;
import com.geopushnetwork.sdk.data.SDKDbHelper;

public class SDKProvider
extends ContentProvider {
    private static final UriMatcher sUriMatcher = SDKProvider.buildUriMatcher();
    private SDKDbHelper mOpenHelper;
    static final int AD = 100;

    static UriMatcher buildUriMatcher() {
        UriMatcher matcher = new UriMatcher(-1);
        String authority = "com.geopushnetwork.sdk";
        matcher.addURI("com.geopushnetwork.sdk", "ads", 100);
        return matcher;
    }

    public boolean onCreate() {
        this.mOpenHelper = new SDKDbHelper(this.getContext());
        return true;
    }

    public String getType(Uri uri) {
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 100: {
                return "vnd.android.cursor.dir/com.geopushnetwork.sdk/ads";
            }
        }
        throw new UnsupportedOperationException("Unknown uri: " + uri);
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Cursor retCursor;
        switch (sUriMatcher.match(uri)) {
            case 100: {
                retCursor = this.mOpenHelper.getReadableDatabase().query("ads", projection, selection, selectionArgs, null, null, sortOrder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        retCursor.setNotificationUri(this.getContext().getContentResolver(), uri);
        return retCursor;
    }

    public Uri insert(Uri uri, ContentValues values) {
        Uri returnUri;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 100: {
                this.normalizeDate(values);
                long _id = db.insert("ads", null, values);
                if (_id > 0L) {
                    returnUri = SDKDataContract.AdEntry.buildAdUri(_id);
                    break;
                }
                throw new SQLException("Failed to insert row into " + uri);
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        return returnUri;
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        int rowsDeleted;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sUriMatcher.match(uri);
        if (null == selection) {
            selection = "1";
        }
        switch (match) {
            case 100: {
                rowsDeleted = db.delete("ads", selection, selectionArgs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        if (rowsDeleted != 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return rowsDeleted;
    }

    private void normalizeDate(ContentValues values) {
        if (values.containsKey("date")) {
            long dateValue = values.getAsLong("date");
            values.put("date", Long.valueOf(SDKDataContract.normalizeDate(dateValue)));
        }
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        int rowsUpdated;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 100: {
                this.normalizeDate(values);
                rowsUpdated = db.update("ads", values, selection, selectionArgs);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown uri: " + uri);
            }
        }
        if (rowsUpdated != 0) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
        return rowsUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] values) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = sUriMatcher.match(uri);
        switch (match) {
            case 100: {
                db.beginTransaction();
                int returnCount = 0;
                try {
                    for (ContentValues value : values) {
                        this.normalizeDate(value);
                        long _id = db.insert("ads", null, value);
                        if (_id == -1L) continue;
                        ++returnCount;
                    }
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
                this.getContext().getContentResolver().notifyChange(uri, null);
                return returnCount;
            }
        }
        return super.bulkInsert(uri, values);
    }

    @TargetApi(value=11)
    public void shutdown() {
        this.mOpenHelper.close();
        super.shutdown();
    }
}

