/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk.data;

import android.content.ContentUris;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.format.Time;

public class SDKDataContract {
    public static final String CONTENT_AUTHORITY = "com.geopushnetwork.sdk";
    public static final Uri BASE_CONTENT_URI = Uri.parse((String)"content://com.geopushnetwork.sdk");
    public static final String PATH_ADS = "ads";

    public static long normalizeDate(long startDate) {
        Time time = new Time();
        time.set(startDate);
        int julianDay = Time.getJulianDay((long)startDate, (long)time.gmtoff);
        return time.setJulianDay(julianDay);
    }

    public static final class AdEntry
    implements BaseColumns {
        public static final Uri CONTENT_URI = BASE_CONTENT_URI.buildUpon().appendPath("ads").build();
        public static final String CONTENT_TYPE = "vnd.android.cursor.dir/com.geopushnetwork.sdk/ads";
        public static final String CONTENT_ITEM_TYPE = "vnd.android.cursor.item/com.geopushnetwork.sdk/ads";
        public static final String TABLE_NAME = "ads";
        public static final String COLUMN_ID = "adid";
        public static final String COLUMN_CATEGORY = "category";
        public static final String COLUMN_ADVERTISER = "advertiser";
        public static final String COLUMN_OLDPRICE = "oldprice";
        public static final String COLUMN_NEWPRICE = "newprice";
        public static final String COLUMN_DISTANCE = "distance";
        public static final String COLUMN_DISCOUNT = "discount";
        public static final String COLUMN_COVER_IMAGE = "coverImage";
        public static final String COLUMN_TYPE = "type";
        public static final String COLUMN_TITLE = "title";
        public static final String COLUMN_DATE = "date";

        public static Uri buildAdUri() {
            return CONTENT_URI.buildUpon().build();
        }

        public static Uri buildAdUri(long id2) {
            return ContentUris.withAppendedId((Uri)CONTENT_URI, (long)id2);
        }

        public static Uri buildAdCategory(String id2) {
            return CONTENT_URI.buildUpon().appendPath(id2).build();
        }

        public static String getCategoryFromUri(Uri uri) {
            return (String)uri.getPathSegments().get(1);
        }
    }
}

