/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.ScrollView;
import android.widget.TextView;
import android.widget.Toast;
import com.geopushnetwork.sdk.Cupom;
import com.geopushnetwork.sdk.CupomActivity;
import com.geopushnetwork.sdk.CupomAdapter;
import com.geopushnetwork.sdk.IBeaconService;
import com.geopushnetwork.sdk.OfferDetail;
import com.geopushnetwork.sdk.R;
import com.geopushnetwork.sdk.data.SDKDataContract;
import com.geopushnetwork.sdk.sync.GPNSyncAdapter;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GPNLib {
    private static String deviceId = "";
    public static String advertiserTel = "";
    public static String offerText = "";
    public static double latitude = 0.0;
    public static double longitude = 0.0;
    public static String version = "0.1";
    public static String channelId = "";

    private static void setDeviceId(Context applicationContext) {
        String LOG = "GPN";
        if (deviceId == "") {
            TelephonyManager tm;
            AdvertisingIdClient.Info adInfo = null;
            try {
                adInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)applicationContext);
            }
            catch (IOException e) {
                Log.e((String)LOG, (String)e.toString());
            }
            catch (GooglePlayServicesNotAvailableException e) {
                Log.e((String)LOG, (String)e.toString());
            }
            catch (IllegalStateException e) {
                Log.e((String)LOG, (String)e.toString());
            }
            catch (GooglePlayServicesRepairableException e) {
                Log.e((String)LOG, (String)e.toString());
            }
            if (adInfo == null) {
                tm = (TelephonyManager)applicationContext.getSystemService("phone");
                deviceId = tm.getDeviceId();
            } else if (adInfo.isLimitAdTrackingEnabled()) {
                tm = (TelephonyManager)applicationContext.getSystemService("phone");
                deviceId = tm.getDeviceId();
            } else {
                deviceId = adInfo.getId();
            }
        }
    }

    public static class RegisterLocation
    extends AsyncTask<String, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;

        public RegisterLocation(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            String adId = params[0];
            try {
                JSONObject jsonObject;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/registerLocation";
                String DEVICE_ID = "deviceId";
                String AD_ID = "adid";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/registerLocation").buildUpon().appendQueryParameter("deviceId", deviceId).appendQueryParameter("adid", adId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObject = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(JSONObject jsonObject) {
            super.onPostExecute((Object)jsonObject);
        }
    }

    public static class RegisterCall
    extends AsyncTask<String, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;

        public RegisterCall(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            String adId = params[0];
            try {
                JSONObject jsonObject;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/registerCall";
                String DEVICE_ID = "deviceId";
                String AD_ID = "adid";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/registerCall").buildUpon().appendQueryParameter("deviceId", deviceId).appendQueryParameter("adid", adId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObject = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(JSONObject jsonObject) {
            super.onPostExecute((Object)jsonObject);
        }
    }

    public static class BeaconSync
    extends AsyncTask<String, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;

        public BeaconSync(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            String adId = params[0];
            try {
                JSONObject jsonObject;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/syncBeacon";
                String DEVICE_ID = "uuid";
                String BEACON_UUID = "beaconuuid";
                String BEACON_MAJOR = "major";
                String BEACON_MINOR = "minor";
                String CHANNEL = "cha";
                String VERSION = "v";
                String OS = "os";
                String uuid = params[0].toUpperCase();
                String major = params[1];
                String minor = params[2];
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/syncBeacon").buildUpon().appendQueryParameter("uuid", deviceId).appendQueryParameter("beaconuuid", uuid).appendQueryParameter("major", major).appendQueryParameter("minor", minor).appendQueryParameter("cha", channelId).appendQueryParameter("v", version).appendQueryParameter("os", "android").build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObject = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(JSONObject jsonObject) {
            super.onPostExecute((Object)jsonObject);
            if (jsonObject != null) {
                try {
                    Intent notifyIntent = new Intent(this.appContext, OfferDetail.class);
                    notifyIntent.putExtra("ID", jsonObject.getString("id"));
                    notifyIntent.setFlags(0x20000000);
                    PendingIntent pendingIntent = PendingIntent.getActivities((Context)this.appContext, (int)0, (Intent[])new Intent[]{notifyIntent}, (int)0x8000000);
                    int icon = this.appContext.getResources().getIdentifier("ic_launcher", "mipmap", this.appContext.getPackageName());
                    Notification notification = new Notification.Builder(this.appContext).setSmallIcon(icon).setContentTitle((CharSequence)jsonObject.getString("t")).setContentText((CharSequence)jsonObject.getString("m")).setAutoCancel(true).setContentIntent(pendingIntent).build();
                    notification.defaults |= 1;
                    NotificationManager notificationManager = (NotificationManager)this.appContext.getSystemService("notification");
                    notificationManager.notify(1, notification);
                }
                catch (JSONException exc) {
                    Log.e((String)"GPN", (String)exc.toString());
                }
            }
        }
    }

    public static class SetImageInBackground
    extends AsyncTask<String, Void, BitmapDrawable> {
        private final String LOG = "GPN";
        private Context appContext;

        public SetImageInBackground(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        protected BitmapDrawable doInBackground(String ... params) {
            Activity activity = (Activity)this.appContext;
            String url = params[0];
            try {
                BitmapDrawable bitmapDrawable = new BitmapDrawable(BitmapFactory.decodeStream((InputStream)new URL(url).openStream()));
                return bitmapDrawable;
            }
            catch (MalformedURLException exc) {
                Log.e((String)"GPN", (String)exc.toString());
            }
            catch (IOException exc) {
                Log.e((String)"GPN", (String)exc.toString());
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(BitmapDrawable img) {
            Activity activity = (Activity)this.appContext;
            ImageView imageView = (ImageView)activity.findViewById(R.id.innerImage);
            imageView.setImageDrawable((Drawable)img);
        }
    }

    public static class GetAddDetail
    extends AsyncTask<String, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;
        private ScrollView scrollView;
        public static double advertiserLatitude = 0.0;
        public static double advertiserLongitude = 0.0;

        public GetAddDetail(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            String adId = params[0];
            try {
                JSONObject jsonObject;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/getDetail";
                String _ID = "id";
                String DEVICE_ID = "deviceId";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/getDetail").buildUpon().appendQueryParameter("id", adId).appendQueryParameter("deviceId", deviceId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObject = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(true);
            this.cp.setVisibility(0);
            this.scrollView = (ScrollView)activity.findViewById(R.id.scrollView);
            this.scrollView.setAlpha(0.15f);
        }

        protected void onPostExecute(final JSONObject jsonObject) {
            final AppCompatActivity activity = (AppCompatActivity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(false);
            ActionBar actionBar = activity.getSupportActionBar();
            if (jsonObject != null) {
                JSONObject advObject;
                try {
                    advObject = jsonObject.getJSONObject("adv");
                    String advertiserName = advObject.getString("n");
                    actionBar.setTitle((CharSequence)advertiserName);
                }
                catch (JSONException exc) {
                    advObject = new JSONObject();
                }
                try {
                    advertiserTel = advObject.getString("te");
                }
                catch (JSONException exc) {
                    advertiserTel = "";
                    Log.e((String)"GPN", (String)exc.toString());
                }
                try {
                    offerText = jsonObject.getString("t");
                }
                catch (JSONException exc) {
                    offerText = "";
                    Log.e((String)"GPN", (String)exc.toString());
                }
                TextView mOfferText = (TextView)activity.findViewById(R.id.gpn_sdk_offer_detail__textview_offerText);
                try {
                    mOfferText.setText((CharSequence)jsonObject.getString("t"));
                }
                catch (JSONException exc) {
                    mOfferText.setText((CharSequence)"-");
                    Log.e((String)"GPN", (String)exc.toString());
                }
                TextView mOldPrice = (TextView)activity.findViewById(R.id.gpn_sdk_offer_detail__textview_oldPrice);
                try {
                    mOldPrice.setText((CharSequence)("De " + DecimalFormat.getCurrencyInstance().format(jsonObject.getDouble("o"))));
                }
                catch (JSONException exc) {
                    mOldPrice.setText((CharSequence)"-");
                    Log.e((String)"GPN", (String)exc.toString());
                }
                TextView mNewPrice = (TextView)activity.findViewById(R.id.gpn_sdk_offer_detail__textview_newPrice);
                try {
                    mNewPrice.setText((CharSequence)("Por " + DecimalFormat.getCurrencyInstance().format(jsonObject.getDouble("n"))));
                }
                catch (JSONException exc) {
                    mNewPrice.setText((CharSequence)"-");
                    Log.e((String)"GPN", (String)exc.toString());
                }
                Button mCupomButton = (Button)activity.findViewById(R.id.gpn_sdk_offer_detail_button_btnCupom);
                try {
                    if (jsonObject.getInt("rc") > 0) {
                        if (jsonObject.getString("cc") != "null") {
                            mCupomButton.setText((CharSequence)"Visualizar Cupom");
                            mCupomButton.setVisibility(0);
                            mCupomButton.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    try {
                                        Intent intent = new Intent(GetAddDetail.this.appContext, CupomActivity.class);
                                        intent.putExtra("CUPOM_CODE", jsonObject.getString("cc"));
                                        activity.startActivity(intent);
                                    }
                                    catch (JSONException exc) {
                                        Toast.makeText((Context)GetAddDetail.this.appContext, (CharSequence)"Erro ao apresentar o cupom.", (int)1).show();
                                        Log.e((String)"GPN", (String)exc.toString());
                                    }
                                }
                            });
                        } else {
                            mCupomButton.setText((CharSequence)"Gerar Cupom");
                            mCupomButton.setVisibility(0);
                            mCupomButton.setOnClickListener(new View.OnClickListener(){

                                public void onClick(View v) {
                                    try {
                                        new RequestCupom(GetAddDetail.this.appContext).execute(new String[]{jsonObject.getString("t"), jsonObject.getString("id")});
                                    }
                                    catch (JSONException exc) {
                                        Log.e((String)"GPN", (String)exc.toString());
                                    }
                                }
                            });
                        }
                    } else if (jsonObject.getString("cc") != "null") {
                        mCupomButton.setText((CharSequence)"Visualizar Cupom");
                        mCupomButton.setVisibility(0);
                        mCupomButton.setOnClickListener(new View.OnClickListener(){

                            public void onClick(View v) {
                                try {
                                    Intent intent = new Intent(GetAddDetail.this.appContext, CupomActivity.class);
                                    intent.putExtra("CUPOM_CODE", jsonObject.getString("cc"));
                                    activity.startActivity(intent);
                                }
                                catch (JSONException exc) {
                                    Toast.makeText((Context)GetAddDetail.this.appContext, (CharSequence)"Erro ao apresentar o cupom.", (int)1).show();
                                    Log.e((String)"GPN", (String)exc.toString());
                                }
                            }
                        });
                    } else {
                        mCupomButton.setVisibility(4);
                    }
                }
                catch (JSONException exc) {
                    Log.e((String)"GPN", (String)exc.toString());
                }
                TextView mValidUntil = (TextView)activity.findViewById(R.id.gpn_sdk_offer_detail__textview_validuntil);
                try {
                    mValidUntil.setText((CharSequence)jsonObject.getString("v"));
                }
                catch (JSONException exc) {
                    mValidUntil.setText((CharSequence)"-");
                    Log.e((String)"GPN", (String)exc.toString());
                }
                TextView mRegulamento = (TextView)activity.findViewById(R.id.gpn_sdk_offer_detail__textview_generalRules);
                try {
                    mRegulamento.setText((CharSequence)jsonObject.getString("r"));
                }
                catch (JSONException exc) {
                    mRegulamento.setText((CharSequence)"-");
                    Log.e((String)"GPN", (String)exc.toString());
                }
                try {
                    advertiserLatitude = advObject.getDouble("la");
                    advertiserLongitude = advObject.getDouble("lo");
                }
                catch (JSONException exc) {
                    Log.e((String)"GPN", (String)exc.toString());
                }
                try {
                    new SetImageInBackground(this.appContext).execute(new String[]{jsonObject.getString("im")});
                }
                catch (JSONException exc) {
                    Log.e((String)"GPN", (String)exc.toString());
                }
            } else {
                Toast.makeText((Context)this.appContext, (CharSequence)"Ocorreu um erro ao carregar as informa\u00e7\u00f5es", (int)1).show();
            }
            this.scrollView.setAlpha(1.0f);
            this.cp.setVisibility(4);
        }
    }

    public static class RequestOfferList
    extends AsyncTask<Void, Void, JSONArray> {
        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;

        public RequestOfferList(Context context) {
            this.appContext = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONArray doInBackground(Void ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            try {
                JSONArray jsonArray;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/sync";
                String DEVICE_ID = "uuid";
                String LATITUDE = "lat";
                String LONGITUDE = "lon";
                String VERSION = "v";
                String OS = "os";
                String CHANNEL = "cha";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/sync").buildUpon().appendQueryParameter("uuid", deviceId).appendQueryParameter("lat", String.valueOf(latitude)).appendQueryParameter("lon", String.valueOf(longitude)).appendQueryParameter("v", version).appendQueryParameter("os", "android").appendQueryParameter("cha", channelId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.setConnectTimeout(10000);
                urlConnection.setReadTimeout(10000);
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONArray jSONArray = null;
                    return jSONArray;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONArray e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONArray jSONArray = jsonArray = new JSONArray(jsonStr);
                return jSONArray;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        protected void onPostExecute(JSONArray jsonArray) {
            super.onPostExecute((Object)jsonArray);
            if (jsonArray != null) {
                Vector<ContentValues> cVVector = new Vector<ContentValues>(jsonArray.length());
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        JSONObject obj = jsonArray.getJSONObject(i);
                        JSONObject adv = obj.getJSONObject("adv");
                        ContentValues adValues = new ContentValues();
                        adValues.put("adid", obj.getString("id"));
                        adValues.put("title", obj.getString("t"));
                        adValues.put("advertiser", adv.getString("n"));
                        adValues.put("category", adv.getString("scat"));
                        adValues.put("discount", Double.valueOf(obj.getDouble("d")));
                        double distance = adv.getDouble("di") * 1000.0;
                        adValues.put("distance", Double.valueOf(distance));
                        adValues.put("oldprice", Double.valueOf(obj.getDouble("o")));
                        adValues.put("newprice", Double.valueOf(obj.getDouble("n")));
                        adValues.put("coverImage", obj.getString("cm"));
                        cVVector.add(adValues);
                        continue;
                    }
                    catch (JSONException exc) {
                        Log.e((String)"GPN", (String)exc.toString());
                    }
                }
                ContentResolver c = this.appContext.getContentResolver();
                c.delete(SDKDataContract.AdEntry.CONTENT_URI, null, null);
                if (cVVector.size() > 0) {
                    ContentValues[] cvArray = new ContentValues[cVVector.size()];
                    cVVector.toArray(cvArray);
                    this.appContext.getContentResolver().bulkInsert(SDKDataContract.AdEntry.CONTENT_URI, cvArray);
                }
                Log.d((String)"GPN", (String)("Sync Complete. " + cVVector.size() + " Inserted"));
            }
        }
    }

    public static class RequestCupomList
    extends AsyncTask<Void, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;

        public RequestCupomList(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(Void ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            try {
                JSONObject jsonObj;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/getCupons";
                String DEVICE_ID = "deviceId";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/getCupons").buildUpon().appendQueryParameter("deviceId", deviceId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObj = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(true);
            this.cp.setVisibility(0);
        }

        protected void onPostExecute(JSONObject jsonObj) {
            super.onPostExecute((Object)jsonObj);
            final Activity activity = (Activity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(false);
            this.cp.setVisibility(4);
            try {
                JSONArray jsonArray = jsonObj.getJSONArray("d");
                if (jsonObj != null) {
                    final ArrayList<Cupom> list = new ArrayList<Cupom>();
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        try {
                            JSONObject obj = jsonArray.getJSONObject(i);
                            Cupom cupom = new Cupom();
                            cupom.code = obj.getString("code");
                            cupom.title = obj.getString("t");
                            cupom.adid = obj.getString("adid");
                            list.add(cupom);
                            continue;
                        }
                        catch (JSONException exc) {
                            Log.e((String)"GPN", (String)exc.toString());
                        }
                    }
                    ListView mListView = (ListView)activity.findViewById(R.id.listView);
                    CupomAdapter adapter = new CupomAdapter(this.appContext, list);
                    mListView.setAdapter((ListAdapter)adapter);
                    mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                            Intent intent = new Intent(activity.getApplicationContext(), CupomActivity.class);
                            intent.putExtra("CUPOM_CODE", ((Cupom)list.get((int)position)).code);
                            activity.startActivity(intent);
                        }
                    });
                    adapter.notifyDataSetChanged();
                } else {
                    Toast.makeText((Context)this.appContext, (CharSequence)"Ocorreu um erro ao carregar as informa\u00e7\u00f5es", (int)1).show();
                }
            }
            catch (JSONException exc) {
                Toast.makeText((Context)this.appContext, (CharSequence)"Ocorreu um erro ao carregar as informa\u00e7\u00f5es", (int)1).show();
            }
        }
    }

    public static class RequestCupom
    extends AsyncTask<String, Void, JSONObject> {
        private final String LOG = "GPN";
        private Context appContext;
        private ProgressBar cp;
        private ScrollView scrollView;
        private String adId;

        public RequestCupom(Context context) {
            this.appContext = context;
            GPNLib.setDeviceId(this.appContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected JSONObject doInBackground(String ... params) {
            HttpURLConnection urlConnection = null;
            BufferedReader reader = null;
            String jsonStr = null;
            String description = params[0];
            this.adId = params[1];
            try {
                JSONObject jsonObject;
                String line;
                String BASE_URL = "http://backend.geopushnetwork.com/mobile/generateCupom";
                String DEVICE_ID = "deviceId";
                String DESCRIPTION = "description";
                String AD_ID = "adId";
                Uri builtUri = Uri.parse((String)"http://backend.geopushnetwork.com/mobile/generateCupom").buildUpon().appendQueryParameter("deviceId", deviceId).appendQueryParameter("description", description).appendQueryParameter("adId", this.adId).build();
                URL url = new URL(builtUri.toString());
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setRequestMethod("GET");
                urlConnection.connect();
                InputStream inputStream = urlConnection.getInputStream();
                StringBuffer buffer = new StringBuffer();
                if (inputStream == null) {
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    buffer.append(line + "\n");
                }
                if (buffer.length() == 0) {
                    JSONObject e = null;
                    return e;
                }
                jsonStr = buffer.toString();
                JSONObject jSONObject = jsonObject = new JSONObject(jsonStr);
                return jSONObject;
            }
            catch (IOException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            catch (JSONException e) {
                Log.e((String)"GPN", (String)"Error ", (Throwable)e);
            }
            finally {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)"GPN", (String)"Error closing stream", (Throwable)e);
                    }
                }
            }
            return null;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            Activity activity = (Activity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(true);
            this.cp.setVisibility(0);
            this.scrollView = (ScrollView)activity.findViewById(R.id.scrollView);
            this.scrollView.setAlpha(0.15f);
        }

        protected void onPostExecute(JSONObject jsonObject) {
            super.onPostExecute((Object)jsonObject);
            Activity activity = (Activity)this.appContext;
            this.cp = (ProgressBar)activity.findViewById(R.id.progressBar);
            this.cp.setIndeterminate(false);
            if (jsonObject != null) {
                Toast.makeText((Context)this.appContext, (CharSequence)"Cupom gerado com sucesso", (int)1).show();
                new GetAddDetail(this.appContext).execute(new String[]{this.adId});
            } else {
                Toast.makeText((Context)this.appContext, (CharSequence)"Ocorreu um erro ao gerar o cupom", (int)1).show();
            }
        }
    }

    public static class Initialize {
        private Context appContext;

        public Initialize(Context context, String channel) {
            this.appContext = context;
            channelId = channel;
            GPNLib.setDeviceId(context);
            GPNSyncAdapter.syncImmediately(context);
            GPNSyncAdapter.initializeSyncAdapter(context);
            context.startService(new Intent(context, IBeaconService.class));
        }
    }
}

