/*
 * Decompiled with CFR 0.152.
 */
package com.geopushnetwork.sdk;

import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.ImageView;
import android.widget.TextView;
import com.geopushnetwork.sdk.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.WriterException;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.qrcode.QRCodeWriter;

public class CupomActivity
extends AppCompatActivity {
    private final String LOG = "GPN";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_cupom);
        Intent intent = this.getIntent();
        ActionBar actionBar = this.getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);
        String code = intent.getStringExtra("CUPOM_CODE");
        TextView cupomCode = (TextView)this.findViewById(R.id.cupomCode);
        cupomCode.setText((CharSequence)code);
        ImageView qrCode = (ImageView)this.findViewById(R.id.qrCode);
        qrCode.setImageBitmap(this.cretaeQRCode(code));
    }

    public boolean onSupportNavigateUp() {
        this.finish();
        return true;
    }

    private Bitmap cretaeQRCode(String text) {
        QRCodeWriter writer = new QRCodeWriter();
        try {
            ByteMatrix bitMatrix = writer.encode(text, BarcodeFormat.QR_CODE, 512, 512);
            int width = 512;
            int height = 512;
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (bitMatrix.get(x, y) == 0) {
                        bmp.setPixel(x, y, -16777216);
                        continue;
                    }
                    bmp.setPixel(x, y, -1);
                }
            }
            return bmp;
        }
        catch (WriterException e) {
            Log.e((String)"GPN", (String)e.toString());
            return null;
        }
    }
}

