package com.geopushnetwork.sdk;

import android.content.Intent;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.net.Uri;
import android.util.Log;

public class OfferDetail extends AppCompatActivity {

    private String LOG = "GPN";
    private String AdId ="";
    private double Latitude = 0;
    private double Longitude = 0;
    private ActionBar actionBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_offer_detail);

        actionBar = getSupportActionBar();
        actionBar.setDisplayHomeAsUpEnabled(true);

        //show progress bar
        AdId = getIntent().getStringExtra("ID");
        new GPNLib.GetAddDetail(this).execute(AdId);

    }



    @Override
    public void onActivityResult(int reqCode, int resultCode, Intent data) {
        if (resultCode == 1) {
            AdId = data.getStringExtra("ID");
        }
    }

    @Override
    public boolean onSupportNavigateUp(){
        finish();
        return true;
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.offerdetail, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        if (id == R.id.action_location) {
            //registrando call
            new GPNLib.RegisterLocation(getApplicationContext()).execute(AdId);


            Intent intent = new Intent(this, LocationActivity.class);
            intent.putExtra("LATITUDE", GPNLib.GetAddDetail.advertiserLatitude);
            intent.putExtra("LONGITUDE", GPNLib.GetAddDetail.advertiserLongitude);
            intent.putExtra("ID", AdId);
            startActivityForResult(intent, 1);
            return true;
        } else if (id == R.id.action_call){
            try {
                //registrando call
                new GPNLib.RegisterCall(getApplicationContext()).execute(AdId);

                //abrindo painel de ligação
                Intent callIntent = new Intent(Intent.ACTION_CALL);
                callIntent.setData(Uri.parse("tel:" + GPNLib.advertiserTel));
                startActivity(callIntent);
                return true;
            } catch (SecurityException exc){
                Log.d(LOG, exc.toString());
            }
        }
        else if (id == R.id.action_share) {
            try {
                Intent sendIntent = new Intent();
                sendIntent.setAction(Intent.ACTION_SEND);
                sendIntent.putExtra(Intent.EXTRA_TEXT, GPNLib.offerText);
                sendIntent.setType("text/plain");
                startActivity(sendIntent);
                return true;
            } catch (SecurityException exc){
                Log.d(LOG, exc.toString());
            }
        }

        return super.onOptionsItemSelected(item);
    }
}
