/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.genonbeta.android.database.CursorItem;
import com.genonbeta.android.database.DatabaseObject;
import com.genonbeta.android.database.SQLQuery;
import java.util.ArrayList;

public abstract class SQLiteDatabase
extends SQLiteOpenHelper {
    private Context mContext;

    public SQLiteDatabase(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.mContext = context;
    }

    public <T extends DatabaseObject> ArrayList<T> castQuery(SQLQuery.Select select, Class<T> clazz) {
        return this.castQuery(select, clazz, null);
    }

    public <T extends DatabaseObject> ArrayList<T> castQuery(SQLQuery.Select select, Class<T> clazz, CastQueryListener<T> listener) {
        ArrayList<DatabaseObject> returnedList = new ArrayList<DatabaseObject>();
        ArrayList<CursorItem> itemList = this.getTable(select);
        try {
            for (CursorItem item : itemList) {
                DatabaseObject newClazz = (DatabaseObject)clazz.newInstance();
                newClazz.reconstruct(item);
                if (listener != null) {
                    listener.onObjectReconstructed(this, item, newClazz);
                }
                returnedList.add(newClazz);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return returnedList;
    }

    public int delete(SQLQuery.Select select) {
        return this.getWritableDatabase().delete(select.tableName, select.where, select.whereArgs);
    }

    public Context getContext() {
        return this.mContext;
    }

    public CursorItem getFirstFromTable(SQLQuery.Select select) {
        ArrayList<CursorItem> list = this.getTable(select.setLimit(1));
        return list.size() > 0 ? list.get(0) : null;
    }

    public ArrayList<CursorItem> getTable(SQLQuery.Select select) {
        ArrayList<CursorItem> list = new ArrayList<CursorItem>();
        Cursor cursor = this.getReadableDatabase().query(select.tableName, select.columns, select.where, select.whereArgs, select.groupBy, select.having, select.orderBy, select.limit);
        if (cursor.moveToFirst()) {
            if (select.loadListener != null) {
                select.loadListener.onOpen(this, cursor);
            }
            do {
                CursorItem item = new CursorItem();
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    item.put(cursor.getColumnName(i), cursor.getString(i));
                }
                if (select.loadListener != null) {
                    select.loadListener.onLoad(this, cursor, item);
                }
                list.add(item);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return list;
    }

    public long insert(DatabaseObject object) {
        object.onCreateObject(this);
        return this.insert(object.getWhere().tableName, null, object.getValues());
    }

    public long insert(String tableName, String nullColumnHack, ContentValues contentValues) {
        return this.getWritableDatabase().insert(tableName, nullColumnHack, contentValues);
    }

    public void publish(DatabaseObject object) {
        if (this.getFirstFromTable(object.getWhere()) != null) {
            this.update(object);
        } else {
            this.insert(object);
        }
    }

    public void remove(DatabaseObject object) {
        object.onRemoveObject(this);
        this.delete(object.getWhere());
    }

    public void reconstruct(DatabaseObject object) throws Exception {
        CursorItem item = this.getFirstFromTable(object.getWhere());
        if (item == null) {
            SQLQuery.Select select = object.getWhere();
            StringBuilder whereArgs = new StringBuilder();
            for (String arg : select.whereArgs) {
                if (whereArgs.length() > 0) {
                    whereArgs.append(", ");
                }
                whereArgs.append("[] ");
                whereArgs.append(arg);
            }
            throw new Exception("No data was returned from: query; tableName: " + select.tableName + "; where: " + select.where + "; whereArgs: " + whereArgs.toString());
        }
        object.reconstruct(item);
    }

    public int update(DatabaseObject object) {
        object.onUpdateObject(this);
        return this.update(object.getWhere(), object.getValues());
    }

    public int update(SQLQuery.Select select, ContentValues values) {
        return this.getWritableDatabase().update(select.tableName, values, select.where, select.whereArgs);
    }

    public static interface CastQueryListener<T extends DatabaseObject> {
        public void onObjectReconstructed(SQLiteDatabase var1, CursorItem var2, T var3);
    }
}

