/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.database;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.util.Log;
import com.genonbeta.android.database.DatabaseObject;
import com.genonbeta.android.database.Progress;
import com.genonbeta.android.database.SQLQuery;
import com.genonbeta.android.database.exception.ReconstructionFailedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class KuickDb
extends SQLiteOpenHelper {
    public static final String TAG = KuickDb.class.getSimpleName();
    public static final String ACTION_DATABASE_CHANGE = "com.genonbeta.database.intent.action.DATABASE_CHANGE";
    public static final String EXTRA_BROADCAST_DATA = "extraBroadcastData";
    public static final String TYPE_REMOVE = "typeRemove";
    public static final String TYPE_INSERT = "typeInsert";
    public static final String TYPE_UPDATE = "typeUpdate";
    private final List<BroadcastData> mBroadcastOverhead = new ArrayList<BroadcastData>();
    private final Context mContext;

    public KuickDb(Context context, String name, SQLiteDatabase.CursorFactory factory, int version) {
        super(context, name, factory, version);
        this.mContext = context;
    }

    public void bindContentValue(SQLiteStatement statement, int iteratorPosition, Object bindingObject) {
        if (bindingObject == null) {
            statement.bindNull(iteratorPosition);
        } else if (bindingObject instanceof Long) {
            statement.bindLong(iteratorPosition, ((Long)bindingObject).longValue());
        } else if (bindingObject instanceof Integer) {
            statement.bindLong(iteratorPosition, (long)((Integer)bindingObject).intValue());
        } else if (bindingObject instanceof Double) {
            statement.bindDouble(iteratorPosition, ((Double)bindingObject).doubleValue());
        } else if (bindingObject instanceof byte[]) {
            statement.bindBlob(iteratorPosition, (byte[])bindingObject);
        } else {
            statement.bindString(iteratorPosition, bindingObject instanceof String ? (String)bindingObject : String.valueOf(bindingObject));
        }
    }

    public <T, V extends DatabaseObject<T>> List<V> castQuery(SQLQuery.Select select, Class<V> clazz) {
        return this.castQuery(select, clazz, null);
    }

    public <T, V extends DatabaseObject<T>> List<V> castQuery(SQLQuery.Select select, Class<V> clazz, CastQueryListener<V> listener) {
        return this.castQuery(this.getReadableDatabase(), select, clazz, listener);
    }

    public <T, V extends DatabaseObject<T>> List<V> castQuery(SQLiteDatabase db, SQLQuery.Select select, Class<V> clazz, CastQueryListener<V> listener) {
        ArrayList<DatabaseObject> returnedList = new ArrayList<DatabaseObject>();
        List<ContentValues> itemList = this.getTable(db, select);
        try {
            for (ContentValues item : itemList) {
                DatabaseObject newClazz = (DatabaseObject)clazz.newInstance();
                newClazz.reconstruct(db, this, item);
                if (listener != null) {
                    listener.onObjectReconstructed(this, item, newClazz);
                }
                returnedList.add(newClazz);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        return returnedList;
    }

    public synchronized void append(SQLiteDatabase db, String tableName, String changeType) {
        this.append(db, tableName, changeType, this.getAffectedRowCount(db));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void append(SQLiteDatabase db, String tableName, String changeType, long affectedRows) {
        if (affectedRows <= 0L) {
            Log.e((String)TAG, (String)("Changelog is not added because there is no change. table: " + tableName + "; change: " + changeType + "; affected rows: " + affectedRows));
            return;
        }
        BroadcastData data = null;
        Object object = this.mBroadcastOverhead;
        synchronized (object) {
            for (BroadcastData testedData : this.mBroadcastOverhead) {
                if (!tableName.equals(testedData.tableName)) continue;
                data = testedData;
                break;
            }
            if (data == null) {
                data = new BroadcastData(tableName);
                this.mBroadcastOverhead.add(data);
            }
        }
        switch (changeType) {
            case "typeInsert": {
                data.inserted = true;
                break;
            }
            case "typeRemove": {
                data.removed = true;
                break;
            }
            case "typeUpdate": {
                data.updated = true;
            }
        }
        data.affectedRowCount = (int)((long)data.affectedRowCount + affectedRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void broadcast() {
        List<BroadcastData> list = this.mBroadcastOverhead;
        synchronized (list) {
            for (BroadcastData data : this.mBroadcastOverhead) {
                this.getContext().sendBroadcast(new Intent(ACTION_DATABASE_CHANGE).putExtra(EXTRA_BROADCAST_DATA, (Serializable)data));
            }
            this.mBroadcastOverhead.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAffectedRowCount(SQLiteDatabase database) {
        long returnCount = 0L;
        try (Cursor cursor = null;){
            cursor = database.rawQuery("SELECT changes() AS affected_row_count", null);
            if (cursor != null && cursor.getCount() > 0 && cursor.moveToFirst()) {
                returnCount = cursor.getLong(cursor.getColumnIndex("affected_row_count"));
            }
        }
        return returnCount;
    }

    public Context getContext() {
        return this.mContext;
    }

    public ContentValues getFirstFromTable(SQLQuery.Select select) {
        return this.getFirstFromTable(this.getReadableDatabase(), select);
    }

    public ContentValues getFirstFromTable(SQLiteDatabase db, SQLQuery.Select select) {
        List<ContentValues> list = this.getTable(db, select.setLimit(1));
        return list.size() > 0 ? list.get(0) : null;
    }

    public List<ContentValues> getTable(SQLQuery.Select select) {
        return this.getTable(this.getReadableDatabase(), select);
    }

    public List<ContentValues> getTable(SQLiteDatabase db, SQLQuery.Select select) {
        ArrayList<ContentValues> list = new ArrayList<ContentValues>();
        Cursor cursor = db.query(select.tableName, select.columns, select.where, select.whereArgs, select.groupBy, select.having, select.orderBy, select.limit);
        if (cursor.moveToFirst()) {
            if (select.loadListener != null) {
                select.loadListener.onOpen(this, cursor);
            }
            int columnCount = cursor.getColumnCount();
            String[] columns = new String[columnCount];
            int[] types = new int[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columns[i] = cursor.getColumnName(i);
                types[i] = cursor.getType(i);
            }
            do {
                ContentValues item = new ContentValues();
                block8: for (int i = 0; i < columnCount; ++i) {
                    String columnName = columns[i];
                    switch (types[i]) {
                        case 1: {
                            item.put(columnName, Long.valueOf(cursor.getLong(i)));
                            continue block8;
                        }
                        case 0: 
                        case 3: {
                            item.put(columnName, cursor.getString(i));
                            continue block8;
                        }
                        case 2: {
                            item.put(columnName, Float.valueOf(cursor.getFloat(i)));
                            continue block8;
                        }
                        case 4: {
                            item.put(columnName, cursor.getBlob(i));
                        }
                    }
                }
                if (select.loadListener != null) {
                    select.loadListener.onLoad(this, cursor, item);
                }
                list.add(item);
            } while (cursor.moveToNext());
        }
        cursor.close();
        return list;
    }

    public <T, V extends DatabaseObject<T>> long insert(V object) {
        return this.insert(this.getWritableDatabase(), object, null, null);
    }

    public <T, V extends DatabaseObject<T>> long insert(SQLiteDatabase db, V object, T parent, Progress.Listener listener) {
        object.onCreateObject(db, this, parent, listener);
        return this.insert(db, object.getWhere().tableName, null, object.getValues());
    }

    public long insert(SQLiteDatabase db, String tableName, String nullColumnHack, ContentValues contentValues) {
        long insertedId = db.insert(tableName, nullColumnHack, contentValues);
        this.append(db, tableName, TYPE_INSERT, insertedId > -1L ? 1L : 0L);
        return insertedId;
    }

    public <T, V extends DatabaseObject<T>> boolean insert(List<V> objects) {
        return this.insert(this.getWritableDatabase(), objects, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean insert(SQLiteDatabase db, List<V> objects, T parent, Progress.Listener listener) {
        db.beginTransaction();
        try {
            Progress.addToTotal(listener, objects.size());
            for (DatabaseObject object : objects) {
                if (!Progress.call(listener, 1)) break;
                this.insert(db, object, parent, listener);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return false;
    }

    public <T, V extends DatabaseObject<T>> int publish(V object) {
        return this.publish(this.getWritableDatabase(), object, null, null);
    }

    public <T, V extends DatabaseObject<T>> int publish(SQLiteDatabase database, V object, T parent, Progress.Listener listener) {
        int rowsChanged = this.update(database, object, parent, listener);
        if (rowsChanged <= 0) {
            rowsChanged = this.insert(database, object, parent, listener) >= -1L ? 1 : 0;
        }
        return rowsChanged;
    }

    public <T, V extends DatabaseObject<T>> boolean publish(List<V> objects) {
        return this.publish(this.getWritableDatabase(), objects, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean publish(SQLiteDatabase db, List<V> objectList, T parent, Progress.Listener listener) {
        db.beginTransaction();
        try {
            Progress.addToTotal(listener, objectList.size());
            for (DatabaseObject object : objectList) {
                if (!Progress.call(listener, 1)) break;
                this.publish(db, object, parent, listener);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return false;
    }

    public <T, V extends DatabaseObject<T>> void reconstruct(V object) throws ReconstructionFailedException {
        this.reconstruct(this.getReadableDatabase(), object);
    }

    public <T, V extends DatabaseObject<T>> void reconstruct(SQLiteDatabase db, V object) throws ReconstructionFailedException {
        ContentValues item = this.getFirstFromTable(db, object.getWhere());
        if (item == null) {
            SQLQuery.Select select = object.getWhere();
            StringBuilder whereArgs = new StringBuilder();
            for (String arg : select.whereArgs) {
                if (whereArgs.length() > 0) {
                    whereArgs.append(", ");
                }
                whereArgs.append("[] ");
                whereArgs.append(arg);
            }
            throw new ReconstructionFailedException("No data was returned from: query; tableName: " + select.tableName + "; where: " + select.where + "; whereArgs: " + whereArgs.toString());
        }
        object.reconstruct(db, this, item);
    }

    public <T, V extends DatabaseObject<T>> void remove(V object) {
        this.remove(this.getWritableDatabase(), object, null, null);
    }

    public <T, V extends DatabaseObject<T>> void remove(SQLiteDatabase db, V object, T parent, Progress.Listener listener) {
        object.onRemoveObject(db, this, parent, listener);
        this.remove(db, object.getWhere());
    }

    public int remove(SQLQuery.Select select) {
        return this.remove(this.getWritableDatabase(), select);
    }

    public int remove(SQLiteDatabase db, SQLQuery.Select select) {
        int affectedRows = db.delete(select.tableName, select.where, select.whereArgs);
        this.append(db, select.tableName, TYPE_REMOVE, affectedRows);
        return affectedRows;
    }

    public <T, V extends DatabaseObject<T>> boolean remove(List<V> objects) {
        return this.remove(this.getWritableDatabase(), objects, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean remove(SQLiteDatabase db, List<V> objects, T parent, Progress.Listener listener) {
        db.beginTransaction();
        try {
            Progress.addToTotal(listener, objects.size());
            for (DatabaseObject object : objects) {
                if (!Progress.call(listener, 1)) break;
                this.remove(db, object, parent, listener);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean removeAsObject(SQLiteDatabase db, SQLQuery.Select select, Class<V> objectType, T parent, Progress.Listener progressListener, CastQueryListener<V> queryListener) {
        db.beginTransaction();
        try {
            List<V> objects = this.castQuery(db, select, objectType, queryListener);
            Progress.addToTotal(progressListener, objects.size());
            for (DatabaseObject object : objects) {
                if (!Progress.call(progressListener, 1)) break;
                this.remove(db, object, parent, progressListener);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return false;
    }

    public <T, V extends DatabaseObject<T>> int update(V object) {
        return this.update(this.getWritableDatabase(), object, null, null);
    }

    public <T, V extends DatabaseObject<T>> int update(SQLiteDatabase db, V object, T parent, Progress.Listener listener) {
        object.onUpdateObject(db, this, parent, listener);
        return this.update(db, object.getWhere(), object.getValues());
    }

    public int update(SQLQuery.Select select, ContentValues values) {
        return this.update(this.getWritableDatabase(), select, values);
    }

    public int update(SQLiteDatabase database, SQLQuery.Select select, ContentValues values) {
        int rowsAffected = database.update(select.tableName, values, select.where, select.whereArgs);
        this.append(database, select.tableName, TYPE_UPDATE, rowsAffected);
        return rowsAffected;
    }

    public <T, V extends DatabaseObject<T>> boolean update(List<V> objects) {
        return this.update(this.getWritableDatabase(), objects, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, V extends DatabaseObject<T>> boolean update(SQLiteDatabase db, List<V> objects, T parent, Progress.Listener listener) {
        db.beginTransaction();
        try {
            Progress.addToTotal(listener, objects.size());
            for (DatabaseObject object : objects) {
                if (!Progress.call(listener, 1)) break;
                this.update(db, object, parent, listener);
            }
            db.setTransactionSuccessful();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            db.endTransaction();
        }
        return false;
    }

    public static BroadcastData toData(Intent intent) {
        return (BroadcastData)intent.getSerializableExtra(EXTRA_BROADCAST_DATA);
    }

    public static class BroadcastData
    implements Serializable {
        public int affectedRowCount = 0;
        public boolean inserted = false;
        public boolean removed = false;
        public boolean updated = false;
        public String tableName;

        BroadcastData(String tableName) {
            this.tableName = tableName;
        }
    }

    public static interface CastQueryListener<T extends DatabaseObject<?>> {
        public void onObjectReconstructed(KuickDb var1, ContentValues var2, T var3);
    }
}

