/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.Utils;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.DefaultBubbleBehavior;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.ScrollerViewProvider;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.ViewBehavior;
import com.genonbeta.android.framework.widget.recyclerview.fastscroll.provider.VisibilityAnimationManager;

public class DefaultScrollerViewProvider
extends ScrollerViewProvider {
    protected View mBubble;
    protected View mHandle;

    @Override
    public View provideHandleView(ViewGroup container) {
        this.mHandle = new View(this.getContext());
        int verticalInset = this.getScroller().isVertical() ? 0 : this.getContext().getResources().getDimensionPixelSize(R.dimen.genfw_fastscroll_handle_inset);
        int horizontalInset = !this.getScroller().isVertical() ? 0 : this.getContext().getResources().getDimensionPixelSize(R.dimen.genfw_fastscroll_handle_inset);
        InsetDrawable handleBg = new InsetDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.genfw_fastscroll_default_handle), horizontalInset, verticalInset, horizontalInset, verticalInset);
        Utils.setBackground(this.mHandle, (Drawable)handleBg);
        int handleWidth = this.getContext().getResources().getDimensionPixelSize(this.getScroller().isVertical() ? R.dimen.genfw_fastscroll_handle_clickable_width : R.dimen.genfw_fastscroll_handle_height);
        int handleHeight = this.getContext().getResources().getDimensionPixelSize(this.getScroller().isVertical() ? R.dimen.genfw_fastscroll_handle_height : R.dimen.genfw_fastscroll_handle_clickable_width);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(handleWidth, handleHeight);
        this.mHandle.setLayoutParams(params);
        return this.mHandle;
    }

    @Override
    public View provideBubbleView(ViewGroup container) {
        this.mBubble = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.genfw_fastscroll_default_bubble, container, false);
        return this.mBubble;
    }

    @Override
    public TextView provideBubbleTextView() {
        return (TextView)this.mBubble;
    }

    @Override
    public int getBubbleOffset() {
        return (int)(this.getScroller().isVertical() ? (float)this.mHandle.getHeight() / 2.0f - (float)this.mBubble.getHeight() : (float)this.mHandle.getWidth() / 2.0f - (float)this.mBubble.getWidth());
    }

    @Override
    protected ViewBehavior provideHandleBehavior() {
        return null;
    }

    @Override
    protected ViewBehavior provideBubbleBehavior() {
        return new DefaultBubbleBehavior((VisibilityAnimationManager)new VisibilityAnimationManager.Builder(this.mBubble).withPivotX(1.0f).withPivotY(1.0f).build());
    }
}

