/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.app;

import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListView;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.app.ListFragment;
import com.genonbeta.android.framework.widget.ListViewAdapter;

public abstract class ListViewFragment<T, E extends ListViewAdapter<T>>
extends ListFragment<ListView, T, E> {
    private ListView mListView;
    private final Handler mHandler = new Handler();
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            ListViewFragment.this.mListView.focusableViewAvailable((View)ListViewFragment.this.mListView);
        }
    };
    private final AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
            ListViewFragment.this.onListItemClick((ListView)parent, v, position, id2);
        }
    };

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = super.onCreateView(inflater, container, savedInstanceState);
        this.mListView = (ListView)view.findViewById(R.id.genfw_customListFragment_listView);
        if (this.mListView == null) {
            this.mListView = this.onListView((View)this.getContainer(), (ViewGroup)this.getListViewContainer());
        }
        this.mListView.setOnItemClickListener(this.mOnClickListener);
        this.mListView.setEmptyView((View)this.getEmptyView());
        return view;
    }

    @Override
    protected ListView onListView(View mainContainer, ViewGroup listViewContainer) {
        ListView listView = new ListView(this.getContext());
        listView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, -1));
        listViewContainer.addView((View)listView);
        return listView;
    }

    @Override
    protected void onEnsureList() {
        this.mListView.setEmptyView((View)this.getEmptyView());
        this.mHandler.post(this.mRequestFocus);
    }

    @Override
    public boolean onSetListAdapter(E adapter) {
        if (this.mListView == null) {
            return false;
        }
        this.mListView.setAdapter(adapter);
        return true;
    }

    public void onListItemClick(ListView l, View v, int position, long id2) {
    }

    @Override
    public ListView getListView() {
        this.onEnsureList();
        return this.mListView;
    }
}

