/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.preference;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.genonbeta.android.database.CursorItem;
import com.genonbeta.android.database.DatabaseObject;
import com.genonbeta.android.database.SQLQuery;
import com.genonbeta.android.database.SQLType;
import com.genonbeta.android.database.SQLValues;
import com.genonbeta.android.database.SQLiteDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DbSharablePreferences
extends SQLiteDatabase
implements SharedPreferences {
    public static final String DATABASE_NAME = DbSharablePreferences.class.getSimpleName() + ".db";
    public static final int DATABASE_VERSION = 1;
    public static final String FIELD_KEY = "__key";
    public static final String FIELD_VALUE = "__value";
    public static final String FIELD_TYPE = "__type";
    private String mCategory;
    private boolean mSyncReliant = false;
    private List<SharedPreferences.OnSharedPreferenceChangeListener> mChangeListener = new ArrayList<SharedPreferences.OnSharedPreferenceChangeListener>();
    private Map<String, Object> mSyncedList = new ArrayMap();
    private AsynchronousUpdateListener mUpdateListener;

    public DbSharablePreferences(Context context, String categoryName, boolean syncReliant) {
        super(context, DATABASE_NAME, null, 1);
        this.mCategory = categoryName;
        this.mSyncReliant = syncReliant;
        this.initialize();
    }

    public DbSharablePreferences(Context context, String categoryName) {
        this(context, categoryName, false);
    }

    public void onCreate(android.database.sqlite.SQLiteDatabase db) {
    }

    public void onUpgrade(android.database.sqlite.SQLiteDatabase db, int oldVersion, int newVersion) {
    }

    private void initialize() {
        SQLValues sqlValues = new SQLValues();
        sqlValues.defineTable(this.mCategory, true).define(new SQLValues.Column(FIELD_KEY, SQLType.TEXT, false)).define(new SQLValues.Column(FIELD_TYPE, SQLType.TEXT, false)).define(new SQLValues.Column(FIELD_VALUE, SQLType.TEXT, true));
        SQLQuery.createTables((android.database.sqlite.SQLiteDatabase)this.getWritableDatabase(), (SQLValues)sqlValues);
        this.setSyncReliant(this.mSyncReliant);
    }

    public Map<String, ?> getAll() {
        List data = this.castQuery(new SQLQuery.Select(this.mCategory, new String[0]), StoredData.class);
        ArrayMap output = new ArrayMap();
        for (StoredData object : data) {
            output.put(object.getKey(), object.getTypedValue());
        }
        return output;
    }

    public synchronized Map<String, ?> getSyncedList() {
        return this.mSyncedList;
    }

    public boolean isSyncReliant() {
        return this.mSyncReliant;
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        return this.valueCast(key, String.class, defValue);
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return null;
    }

    public int getInt(String key, int defValue) {
        return this.valueCast(key, Integer.class, defValue);
    }

    public long getLong(String key, long defValue) {
        return this.valueCast(key, Long.class, defValue);
    }

    public float getFloat(String key, float defValue) {
        return this.valueCast(key, Float.class, Float.valueOf(defValue)).floatValue();
    }

    public boolean getBoolean(String key, boolean defValue) {
        return this.valueCast(key, Boolean.class, defValue);
    }

    public boolean contains(String key) {
        if (this.isSyncReliant()) {
            return this.mSyncedList.containsKey(key);
        }
        try {
            this.reconstruct(new StoredData(this.mCategory, key));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public SharedPreferences.Editor edit() {
        return new DbEditor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mChangeListener.add(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mChangeListener.remove(listener);
    }

    public void setSyncReliant(boolean syncReliant) {
        this.mSyncReliant = syncReliant;
        if (syncReliant) {
            this.sync();
        }
    }

    public DbSharablePreferences setUpdateListener(AsynchronousUpdateListener updateListener) {
        this.mUpdateListener = updateListener;
        return this;
    }

    public void sync() {
        this.mSyncedList = new ArrayMap();
        this.mSyncedList.putAll(this.getAll());
    }

    public <T> T valueCast(String key, Class<T> clazz, T defaultValue) {
        if (this.isSyncReliant()) {
            if (this.getSyncedList().containsKey(key)) {
                return (T)this.getSyncedList().get(key);
            }
        } else {
            StoredData data = new StoredData(this.mCategory, key);
            try {
                this.reconstruct(data);
                return (T)data.getTypedValue();
            }
            catch (Exception e) {
                Log.d((String)DbSharablePreferences.class.getSimpleName(), (String)("Failed to read and returning the default value: " + key + "; default: " + defaultValue + "; requested type: " + clazz.getSimpleName() + "; error msg: " + e.getMessage()));
            }
        }
        return defaultValue;
    }

    public static interface AsynchronousUpdateListener {
        public void onCommitComplete();
    }

    public class DbEditor
    implements SharedPreferences.Editor {
        private List<StoredData> mPendingPublish = new ArrayList<StoredData>();
        private List<StoredData> mPendingRemoval = new ArrayList<StoredData>();

        protected void execute() {
            ArrayMap passiveSyncList = new ArrayMap();
            if (DbSharablePreferences.this.isSyncReliant()) {
                passiveSyncList.putAll(DbSharablePreferences.this.mSyncedList);
            }
            ArrayList<StoredData> pendingRemoval = new ArrayList<StoredData>(this.mPendingRemoval);
            ArrayList<StoredData> pendingPublish = new ArrayList<StoredData>(this.mPendingPublish);
            for (StoredData removal : pendingRemoval) {
                DbSharablePreferences.this.remove(removal);
                if (DbSharablePreferences.this.isSyncReliant()) {
                    passiveSyncList.remove(removal.getKey());
                }
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : DbSharablePreferences.this.mChangeListener) {
                    listener.onSharedPreferenceChanged((SharedPreferences)DbSharablePreferences.this, removal.getKey());
                }
            }
            for (StoredData publish : pendingPublish) {
                DbSharablePreferences.this.publish(publish);
                if (DbSharablePreferences.this.isSyncReliant()) {
                    passiveSyncList.put(publish.getKey(), publish.getTypedValue());
                }
                for (SharedPreferences.OnSharedPreferenceChangeListener listener : DbSharablePreferences.this.mChangeListener) {
                    listener.onSharedPreferenceChanged((SharedPreferences)DbSharablePreferences.this, publish.getKey());
                }
            }
            this.mPendingRemoval = new ArrayList<StoredData>();
            this.mPendingPublish = new ArrayList<StoredData>();
            if (DbSharablePreferences.this.isSyncReliant()) {
                DbSharablePreferences.this.mSyncedList = (Map)passiveSyncList;
                if (DbSharablePreferences.this.mUpdateListener != null) {
                    DbSharablePreferences.this.mUpdateListener.onCommitComplete();
                }
            }
        }

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            this.mPendingPublish.add(new StoredData(DbSharablePreferences.this.mCategory, key, value));
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            this.mPendingPublish.add(new StoredData(DbSharablePreferences.this.mCategory, key, value));
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            this.mPendingPublish.add(new StoredData(DbSharablePreferences.this.mCategory, key, value));
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            this.mPendingPublish.add(new StoredData(DbSharablePreferences.this.mCategory, key, value));
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            this.mPendingPublish.add(new StoredData(DbSharablePreferences.this.mCategory, key, value));
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mPendingRemoval.add(new StoredData(DbSharablePreferences.this.mCategory, key));
            return this;
        }

        public SharedPreferences.Editor clear() {
            DbSharablePreferences.this.remove(new SQLQuery.Select(DbSharablePreferences.this.mCategory, new String[0]));
            return this;
        }

        public boolean commit() {
            this.apply();
            return true;
        }

        public void apply() {
            if (DbSharablePreferences.this.isSyncReliant()) {
                new Thread(){

                    @Override
                    public void run() {
                        DbEditor.this.execute();
                    }
                }.run();
            } else {
                this.execute();
            }
        }
    }

    public static enum Type {
        INTEGER,
        STRING,
        FLOAT,
        BOOLEAN,
        LONG;

    }

    public static class StoredData
    implements DatabaseObject<Object> {
        private String mCategory;
        private String mKey;
        private String mValue;
        private Type mType;

        public StoredData() {
        }

        public StoredData(String category, String key) {
            this.mCategory = category;
            this.mKey = key;
        }

        public StoredData(String category, String key, Object value, Type type) {
            this(category, key);
            this.mType = type;
            if (value != null) {
                this.mValue = String.valueOf(value);
            }
        }

        public StoredData(String category, String key, boolean value) {
            this(category, key, value, Type.BOOLEAN);
        }

        public StoredData(String category, String key, float value) {
            this(category, key, Float.valueOf(value), Type.FLOAT);
        }

        public StoredData(String category, String key, int value) {
            this(category, key, value, Type.INTEGER);
        }

        public StoredData(String category, String key, long value) {
            this(category, key, value, Type.LONG);
        }

        public StoredData(String category, String key, String value) {
            this(category, key, value, Type.STRING);
        }

        public String getKey() {
            return this.mKey;
        }

        public Type getType() {
            return this.mType;
        }

        public Object getTypedValue() {
            try {
                switch (this.mType) {
                    case BOOLEAN: {
                        return Boolean.valueOf(this.mValue);
                    }
                    case FLOAT: {
                        return Float.valueOf(this.mValue);
                    }
                    case INTEGER: {
                        return Integer.valueOf(this.mValue);
                    }
                    case LONG: {
                        return Long.valueOf(this.mValue);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.mValue;
        }

        public SQLQuery.Select getWhere() {
            return new SQLQuery.Select(this.mCategory, new String[0]).setWhere("__key=?", new String[]{this.mKey});
        }

        public ContentValues getValues() {
            ContentValues values = new ContentValues();
            values.put(DbSharablePreferences.FIELD_KEY, this.mKey);
            values.put(DbSharablePreferences.FIELD_VALUE, String.valueOf(this.mValue));
            values.put(DbSharablePreferences.FIELD_TYPE, this.mType.toString());
            return values;
        }

        public void reconstruct(CursorItem item) {
            this.mKey = item.getString(DbSharablePreferences.FIELD_KEY);
            this.mValue = item.getString(DbSharablePreferences.FIELD_VALUE);
            this.mType = Type.valueOf(item.getString(DbSharablePreferences.FIELD_TYPE));
        }

        public void onCreateObject(android.database.sqlite.SQLiteDatabase dbInstance, SQLiteDatabase database, Object parent) {
        }

        public void onUpdateObject(android.database.sqlite.SQLiteDatabase dbInstance, SQLiteDatabase database, Object parent) {
        }

        public void onRemoveObject(android.database.sqlite.SQLiteDatabase dbInstance, SQLiteDatabase database, Object parent) {
        }
    }
}

