/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.app;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.AsyncTaskLoader;
import androidx.loader.content.Loader;
import com.genonbeta.android.framework.R;
import com.genonbeta.android.framework.app.Fragment;
import com.genonbeta.android.framework.app.ListFragmentImpl;
import com.genonbeta.android.framework.widget.ListAdapterImpl;
import java.util.ArrayList;

public abstract class ListFragment<Z extends ViewGroup, T, E extends ListAdapterImpl<T>>
extends Fragment
implements ListFragmentImpl<T> {
    public static final String TAG = "ListFragment";
    public static final int TASK_ID_REFRESH = 0;
    private E mAdapter;
    private ViewGroup mListViewContainer;
    private ViewGroup mCustomViewContainer;
    private ViewGroup mDefaultViewContainer;
    private ViewGroup mContainer;
    private ViewGroup mEmptyView;
    private TextView mEmptyText;
    private ImageView mEmptyImage;
    private ProgressBar mProgressView;
    private Button mEmptyActionButton;
    private LoaderCallbackRefresh mLoaderCallbackRefresh = new LoaderCallbackRefresh();

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mAdapter = this.onAdapter();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        View view = this.getLayoutInflater().inflate(R.layout.genfw_abstract_list_fragment, container, false);
        this.mCustomViewContainer = (ViewGroup)view.findViewById(R.id.genfw_customListFragment_customViewContainer);
        this.mDefaultViewContainer = (ViewGroup)view.findViewById(R.id.genfw_customListFragment_defaultViewContainer);
        this.mListViewContainer = (ViewGroup)view.findViewById(R.id.genfw_customListFragment_listViewContainer);
        this.mContainer = (ViewGroup)view.findViewById(R.id.genfw_customListFragment_container);
        this.mEmptyView = (ViewGroup)view.findViewById(R.id.genfw_customListFragment_emptyView);
        this.mEmptyText = (TextView)view.findViewById(R.id.genfw_customListFragment_emptyTextView);
        this.mEmptyImage = (ImageView)view.findViewById(R.id.genfw_customListFragment_emptyImageView);
        this.mProgressView = (ProgressBar)view.findViewById(R.id.genfw_customListFragment_progressView);
        this.mEmptyActionButton = (Button)view.findViewById(R.id.genfw_customListFragment_emptyActionButton);
        return view;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getListView() != null && this.getListView().getId() != R.id.genfw_customListFragment_listView) {
            this.getListView().setId(R.id.genfw_customListFragment_listView);
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.setListAdapter(this.mAdapter);
        this.getLoaderManager().initLoader(0, null, (LoaderManager.LoaderCallbacks)this.mLoaderCallbackRefresh);
    }

    public abstract E onAdapter();

    protected abstract void onEnsureList();

    protected abstract Z onListView(View var1, ViewGroup var2);

    public abstract boolean onSetListAdapter(E var1);

    public abstract Z getListView();

    protected void onPrepareRefreshingList() {
    }

    protected void onListRefreshed() {
    }

    public AsyncTaskLoader<ArrayList<T>> createLoader() {
        return new ListLoader(this.mAdapter);
    }

    public E getAdapter() {
        return this.mAdapter;
    }

    protected ViewGroup getContainer() {
        return this.mContainer;
    }

    public ViewGroup getCustomViewContainer() {
        return this.mCustomViewContainer;
    }

    public ViewGroup getDefaultViewContainer() {
        return this.mDefaultViewContainer;
    }

    public ImageView getEmptyImage() {
        this.onEnsureList();
        return this.mEmptyImage;
    }

    public TextView getEmptyText() {
        this.onEnsureList();
        return this.mEmptyText;
    }

    protected ViewGroup getEmptyView() {
        return this.mEmptyView;
    }

    protected ViewGroup getListViewContainer() {
        return this.mListViewContainer;
    }

    public LoaderCallbackRefresh getLoaderCallbackRefresh() {
        return this.mLoaderCallbackRefresh;
    }

    public E getListAdapter() {
        return this.mAdapter;
    }

    public ProgressBar getProgressView() {
        this.onEnsureList();
        return this.mProgressView;
    }

    public Button getEmptyActionButton() {
        return this.mEmptyActionButton;
    }

    @Override
    public void refreshList() {
        this.getLoaderCallbackRefresh().requestRefresh();
    }

    public void setEmptyImage(int resId) {
        this.onEnsureList();
        this.mEmptyImage.setImageResource(resId);
    }

    public void setEmptyText(CharSequence text) {
        this.onEnsureList();
        this.mEmptyText.setText(text);
    }

    public void setListAdapter(E adapter) {
        boolean hadAdapter = this.mAdapter != null;
        this.mAdapter = adapter;
        if (this.onSetListAdapter(adapter) && this.mContainer.getVisibility() != 0 && !hadAdapter) {
            this.setListShown(true, this.getView().getWindowToken() != null);
        }
    }

    public void setListShown(boolean shown) {
        this.setListShown(shown, true);
    }

    public void setListShown(boolean shown, boolean animate) {
        this.onEnsureList();
        if (this.mContainer.getVisibility() == 0 == shown) {
            return;
        }
        if (animate) {
            Animation fadeOut = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001);
            Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000);
            this.mProgressView.startAnimation(shown ? fadeOut : fadeIn);
            this.mContainer.startAnimation(shown ? fadeIn : fadeOut);
        } else {
            this.mProgressView.clearAnimation();
            this.mContainer.clearAnimation();
        }
        this.mContainer.setVisibility(shown ? 0 : 8);
        this.mProgressView.setVisibility(shown ? 8 : 0);
    }

    public void showCustomView(boolean shown) {
        this.mCustomViewContainer.setVisibility(shown ? 0 : 8);
        this.mDefaultViewContainer.setVisibility(shown ? 8 : 0);
    }

    public boolean toggleCustomView() {
        boolean isVisible = this.getCustomViewContainer().getVisibility() == 0;
        this.showCustomView(!isVisible);
        return !isVisible;
    }

    public void useEmptyActionButton(String buttonText, View.OnClickListener clickListener) {
        this.mEmptyActionButton.setText((CharSequence)buttonText);
        this.mEmptyActionButton.setOnClickListener(clickListener);
        this.useEmptyActionButton(true);
    }

    public void useEmptyActionButton(boolean use) {
        this.mEmptyActionButton.setVisibility(use ? 0 : 8);
    }

    public static class ListLoader<G>
    extends AsyncTaskLoader<ArrayList<G>> {
        private ListAdapterImpl<G> mAdapter;

        public ListLoader(ListAdapterImpl<G> adapter) {
            super(adapter.getContext());
            this.mAdapter = adapter;
        }

        protected void onStartLoading() {
            super.onStartLoading();
            this.forceLoad();
        }

        public ArrayList<G> loadInBackground() {
            return this.mAdapter.onLoad();
        }
    }

    private class LoaderCallbackRefresh
    implements LoaderManager.LoaderCallbacks<ArrayList<T>> {
        private boolean mRunning = false;
        private boolean mReloadRequested = false;

        private LoaderCallbackRefresh() {
        }

        @NonNull
        public Loader<ArrayList<T>> onCreateLoader(int id2, Bundle args) {
            this.mReloadRequested = false;
            this.mRunning = true;
            if (ListFragment.this.mAdapter.getCount() == 0) {
                ListFragment.this.setListShown(false);
            }
            return ListFragment.this.createLoader();
        }

        public void onLoadFinished(Loader<ArrayList<T>> loader, ArrayList<T> data) {
            if (ListFragment.this.isResumed()) {
                ListFragment.this.onPrepareRefreshingList();
                ListFragment.this.mAdapter.onUpdate(data);
                ListFragment.this.mAdapter.onDataSetChanged();
                ListFragment.this.setListShown(true);
                ListFragment.this.onListRefreshed();
            }
            if (this.isReloadRequested()) {
                this.refresh();
            }
            this.mRunning = false;
        }

        public void onLoaderReset(@NonNull Loader<ArrayList<T>> loader) {
        }

        public boolean isRunning() {
            return this.mRunning;
        }

        public boolean isReloadRequested() {
            return this.mReloadRequested;
        }

        public void refresh() {
            ListFragment.this.getLoaderManager().restartLoader(0, null, (LoaderManager.LoaderCallbacks)ListFragment.this.mLoaderCallbackRefresh);
        }

        public boolean requestRefresh() {
            if (this.isRunning() && this.isReloadRequested()) {
                return false;
            }
            if (!this.isRunning()) {
                this.refresh();
            } else {
                this.mReloadRequested = true;
            }
            return true;
        }
    }
}

