/*
 * Decompiled with CFR 0.152.
 */
package com.genonbeta.android.framework.io;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import androidx.annotation.RequiresApi;
import com.genonbeta.android.framework.io.LocalDocumentFile;
import com.genonbeta.android.framework.io.StreamDocumentFile;
import com.genonbeta.android.framework.io.StreamInfo;
import com.genonbeta.android.framework.io.TreeDocumentFile;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;

public abstract class DocumentFile {
    public static final String TAG = DocumentFile.class.getSimpleName();
    private final DocumentFile mParent;

    public DocumentFile(DocumentFile parent) {
        this.mParent = parent;
    }

    public static DocumentFile fromFile(File file) {
        return new LocalDocumentFile(null, file);
    }

    public static DocumentFile fromUri(Context context, Uri uri, boolean prepareTree) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                return new TreeDocumentFile(null, context, prepareTree ? DocumentFile.prepareUri(uri) : uri);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            return new StreamDocumentFile(new StreamInfo(context, uri));
        }
        catch (Exception exception) {
            throw new FileNotFoundException("Failed to create right connection for " + uri.toString());
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof DocumentFile && this.getUri() != null && this.getUri().equals((Object)((DocumentFile)obj).getUri());
    }

    public abstract DocumentFile createFile(String var1, String var2);

    public abstract DocumentFile createDirectory(String var1);

    public abstract Uri getUri();

    public abstract String getName();

    public abstract String getType();

    public DocumentFile getParentFile() {
        return this.mParent;
    }

    public abstract boolean isDirectory();

    public abstract boolean isFile();

    public abstract boolean isVirtual();

    public abstract long lastModified();

    public abstract long length();

    public abstract boolean canRead();

    public abstract boolean canWrite();

    public abstract boolean delete();

    public abstract boolean exists();

    public abstract DocumentFile[] listFiles();

    public DocumentFile findFile(String displayName) {
        for (DocumentFile doc : this.listFiles()) {
            if (!displayName.equals(doc.getName())) continue;
            return doc;
        }
        return null;
    }

    public abstract boolean renameTo(String var1);

    public abstract void sync() throws Exception;

    protected static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @RequiresApi(value=21)
    protected static Uri prepareUri(Uri treeUri) {
        return DocumentsContract.buildDocumentUriUsingTree((Uri)treeUri, (String)DocumentsContract.getTreeDocumentId((Uri)treeUri));
    }
}

