/*
 * Decompiled with CFR 0.152.
 */
package com.leo.superrecyclerview.widgets;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.widget.FrameLayout;
import com.leo.superrecyclerview.R;

public class SuperRecyclerView
extends FrameLayout {
    protected int ITEM_LEFT_TO_LOAD_MORE = 10;
    protected RecyclerView mRecycler;
    protected ViewStub mProgress;
    protected ViewStub mEmpty;
    protected View mProgressView;
    protected View mEmptyView;
    protected boolean mClipToPadding;
    protected int mPadding;
    protected int mPaddingTop;
    protected int mPaddingBottom;
    protected int mPaddingLeft;
    protected int mPaddingRight;
    protected int mScrollbarStyle;
    protected int mEmptyId;
    protected RecyclerView.OnScrollListener mInternalOnScrollListener;
    protected RecyclerView.OnScrollListener mExternalOnScrollListener;
    protected SwipeRefreshLayout mPtrLayout;
    protected int mSuperRecyclerViewMainLayout;
    private int mProgressId;

    public SwipeRefreshLayout getSwipeToRefresh() {
        return this.mPtrLayout;
    }

    public RecyclerView getRecyclerView() {
        return this.mRecycler;
    }

    public SuperRecyclerView(Context context) {
        super(context);
        this.initView();
    }

    public SuperRecyclerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.initView();
    }

    public SuperRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(attrs);
        this.initView();
    }

    protected void initAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.superrecyclerview);
        try {
            this.mSuperRecyclerViewMainLayout = a.getResourceId(R.styleable.superrecyclerview_mainLayoutId, R.layout.layout_progress_recyclerview);
            this.mClipToPadding = a.getBoolean(R.styleable.superrecyclerview_recyclerClipToPadding, false);
            this.mPadding = (int)a.getDimension(R.styleable.superrecyclerview_recyclerPadding, -1.0f);
            this.mPaddingTop = (int)a.getDimension(R.styleable.superrecyclerview_recyclerPaddingTop, 0.0f);
            this.mPaddingBottom = (int)a.getDimension(R.styleable.superrecyclerview_recyclerPaddingBottom, 0.0f);
            this.mPaddingLeft = (int)a.getDimension(R.styleable.superrecyclerview_recyclerPaddingLeft, 0.0f);
            this.mPaddingRight = (int)a.getDimension(R.styleable.superrecyclerview_recyclerPaddingRight, 0.0f);
            this.mScrollbarStyle = a.getInt(R.styleable.superrecyclerview_scrollbarStyle, -1);
            this.mEmptyId = a.getResourceId(R.styleable.superrecyclerview_layout_empty, 0);
            this.mProgressId = a.getResourceId(R.styleable.superrecyclerview_layout_progress, R.layout.layout_progress);
        }
        finally {
            a.recycle();
        }
    }

    private void initView() {
        if (this.isInEditMode()) {
            return;
        }
        View v = LayoutInflater.from((Context)this.getContext()).inflate(this.mSuperRecyclerViewMainLayout, (ViewGroup)this);
        this.mPtrLayout = (SwipeRefreshLayout)v.findViewById(R.id.ptr_layout);
        this.mPtrLayout.setEnabled(false);
        this.mProgress = (ViewStub)v.findViewById(16908301);
        this.mProgress.setLayoutResource(this.mProgressId);
        this.mProgressView = this.mProgress.inflate();
        this.mEmpty = (ViewStub)v.findViewById(R.id.empty);
        this.mEmpty.setLayoutResource(this.mEmptyId);
        if (this.mEmptyId != 0) {
            this.mEmptyView = this.mEmpty.inflate();
        }
        this.mEmpty.setVisibility(8);
        this.initRecyclerView(v);
    }

    protected void initRecyclerView(View view) {
        View recyclerView = view.findViewById(16908298);
        if (!(recyclerView instanceof RecyclerView)) {
            throw new IllegalArgumentException("SuperRecyclerView works with a RecyclerView!");
        }
        this.mRecycler = (RecyclerView)recyclerView;
        if (this.mRecycler != null) {
            this.mRecycler.setHasFixedSize(true);
            this.mRecycler.setClipToPadding(this.mClipToPadding);
            this.mInternalOnScrollListener = new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    if (SuperRecyclerView.this.mExternalOnScrollListener != null) {
                        SuperRecyclerView.this.mExternalOnScrollListener.onScrolled(recyclerView, dx, dy);
                    }
                }

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    super.onScrollStateChanged(recyclerView, newState);
                    if (SuperRecyclerView.this.mExternalOnScrollListener != null) {
                        SuperRecyclerView.this.mExternalOnScrollListener.onScrollStateChanged(recyclerView, newState);
                    }
                }
            };
            this.mRecycler.addOnScrollListener(this.mInternalOnScrollListener);
            if ((float)this.mPadding != -1.0f) {
                this.mRecycler.setPadding(this.mPadding, this.mPadding, this.mPadding, this.mPadding);
            } else {
                this.mRecycler.setPadding(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
            }
            if (this.mScrollbarStyle != -1) {
                this.mRecycler.setScrollBarStyle(this.mScrollbarStyle);
            }
        }
    }

    public void setLayoutManager(RecyclerView.LayoutManager manager) {
        this.mRecycler.setLayoutManager(manager);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        this.mRecycler.setAdapter(adapter);
        this.mProgress.setVisibility(8);
        this.mRecycler.setVisibility(0);
        this.mPtrLayout.setRefreshing(false);
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.update();
            }

            public void onChanged() {
                super.onChanged();
                this.update();
            }

            private void update() {
                SuperRecyclerView.this.mProgress.setVisibility(8);
                SuperRecyclerView.this.mPtrLayout.setRefreshing(false);
                if (SuperRecyclerView.this.mRecycler.getAdapter().getItemCount() == 0 && SuperRecyclerView.this.mEmptyId != 0) {
                    SuperRecyclerView.this.mEmpty.setVisibility(0);
                } else if (SuperRecyclerView.this.mEmptyId != 0) {
                    SuperRecyclerView.this.mEmpty.setVisibility(8);
                }
            }
        });
        if ((adapter == null || adapter.getItemCount() == 0) && this.mEmptyId != 0) {
            this.mEmpty.setVisibility(0);
        } else if (this.mEmptyId != 0) {
            this.mEmpty.setVisibility(8);
        }
    }

    public void setProgressAdapter(RecyclerView.Adapter adapter) {
        this.mRecycler.setAdapter(adapter);
        this.mProgress.setVisibility(0);
        this.mRecycler.setVisibility(8);
        this.mEmpty.setVisibility(8);
        this.mPtrLayout.setRefreshing(false);
        adapter.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                this.update();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                this.update();
            }

            public void onChanged() {
                super.onChanged();
                this.update();
            }

            private void update() {
                SuperRecyclerView.this.mProgress.setVisibility(8);
                SuperRecyclerView.this.mPtrLayout.setRefreshing(false);
                SuperRecyclerView.this.mRecycler.setVisibility(0);
                if (SuperRecyclerView.this.mRecycler.getAdapter().getItemCount() == 0 && SuperRecyclerView.this.mEmptyId != 0) {
                    SuperRecyclerView.this.mEmpty.setVisibility(0);
                } else if (SuperRecyclerView.this.mEmptyId != 0) {
                    SuperRecyclerView.this.mEmpty.setVisibility(8);
                }
            }
        });
    }

    public void clear() {
        this.mRecycler.setAdapter(null);
    }

    public void showProgress() {
        this.hideRecycler();
        if (this.mEmptyId != 0) {
            this.mEmpty.setVisibility(4);
        }
        this.mProgress.setVisibility(0);
    }

    public void showRecycler() {
        this.hideProgress();
        this.mRecycler.setVisibility(0);
    }

    public void setRefreshListener(SwipeRefreshLayout.OnRefreshListener listener) {
        this.mPtrLayout.setEnabled(true);
        this.mPtrLayout.setOnRefreshListener(listener);
    }

    public void setRefreshingColorResources(int colRes1, int colRes2, int colRes3, int colRes4) {
        this.mPtrLayout.setColorSchemeResources(new int[]{colRes1, colRes2, colRes3, colRes4});
    }

    public void setRefreshingColor(int col1, int col2, int col3, int col4) {
        this.mPtrLayout.setColorSchemeColors(new int[]{col1, col2, col3, col4});
    }

    public void hideProgress() {
        this.mProgress.setVisibility(8);
    }

    public void hideRecycler() {
        this.mRecycler.setVisibility(8);
    }

    public void setOnScrollListener(RecyclerView.OnScrollListener listener) {
        this.mExternalOnScrollListener = listener;
    }

    public void addOnItemTouchListener(RecyclerView.OnItemTouchListener listener) {
        this.mRecycler.addOnItemTouchListener(listener);
    }

    public void removeOnItemTouchListener(RecyclerView.OnItemTouchListener listener) {
        this.mRecycler.removeOnItemTouchListener(listener);
    }

    public RecyclerView.Adapter getAdapter() {
        return this.mRecycler.getAdapter();
    }

    public void setNumberBeforeMoreIsCalled(int max) {
        this.ITEM_LEFT_TO_LOAD_MORE = max;
    }

    public void setOnTouchListener(View.OnTouchListener listener) {
        this.mRecycler.setOnTouchListener(listener);
    }

    public void setItemAnimator(RecyclerView.ItemAnimator animator) {
        this.mRecycler.setItemAnimator(animator);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecycler.addItemDecoration(itemDecoration);
    }

    public void addItemDecoration(RecyclerView.ItemDecoration itemDecoration, int index) {
        this.mRecycler.addItemDecoration(itemDecoration, index);
    }

    public void removeItemDecoration(RecyclerView.ItemDecoration itemDecoration) {
        this.mRecycler.removeItemDecoration(itemDecoration);
    }

    public View getProgressView() {
        return this.mProgressView;
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    public static enum LAYOUT_MANAGER_TYPE {
        LINEAR,
        GRID,
        STAGGERED_GRID;

    }
}

