/*
 * Decompiled with CFR 0.152.
 */
package com.leo.superrecyclerview.adapters;

import com.leo.superrecyclerview.R;
import com.leo.superrecyclerview.adapters.CommonAdapter;
import com.leo.superrecyclerview.models.ViewItem;
import java.util.ArrayList;
import java.util.List;

public abstract class LoadMoreAdapter
extends CommonAdapter<ViewItem> {
    public static final int VIEW_TYPE_ITEM_LOAD_MORE = 2015063009;
    private int loadMoreLayoutId = R.layout.layout_more_progress;
    private boolean isLoading;
    private boolean isLoadingCompleted;
    private int pageCount = 25;
    private ILoadMoreCallback callback;

    public LoadMoreAdapter(List<ViewItem> mDatas) {
        super(mDatas);
        if (this.mDatas.size() >= this.pageCount) {
            this.mDatas.add(this.getLoadMoreItem());
        }
    }

    public LoadMoreAdapter(int pageCount, List<ViewItem> mDatas) {
        super(mDatas);
        this.pageCount = pageCount;
        if (this.mDatas.size() >= pageCount) {
            this.mDatas.add(this.getLoadMoreItem());
        }
    }

    public LoadMoreAdapter(List<ViewItem> mDatas, int loadMoreLayoutId) {
        super(mDatas);
        this.loadMoreLayoutId = loadMoreLayoutId;
        if (this.mDatas.size() >= this.pageCount) {
            this.mDatas.add(this.getLoadMoreItem());
        }
    }

    public LoadMoreAdapter(int pageCount, List<ViewItem> mDatas, int loadMoreLayoutId) {
        super(mDatas);
        this.pageCount = pageCount;
        this.loadMoreLayoutId = loadMoreLayoutId;
        if (this.mDatas.size() >= pageCount) {
            this.mDatas.add(this.getLoadMoreItem());
        }
    }

    @Override
    public int getLayoutId(int viewType) {
        if (viewType == 2015063009) {
            return this.loadMoreLayoutId;
        }
        return this.getNormalLayoutId();
    }

    public abstract int getNormalLayoutId();

    public void onBindViewHolder(CommonAdapter.CommonViewHolder holder, int position) {
        if (position == this.mDatas.size() - 1 && position >= this.pageCount - 1 && !this.isLoading && !this.isLoadingCompleted) {
            this.isLoading = true;
            if (this.callback != null) {
                this.callback.loadMore(position);
            }
        }
    }

    public int getItemViewType(int position) {
        ViewItem viewItem = (ViewItem)this.mDatas.get(position);
        return viewItem.viewType;
    }

    @Override
    public void addAll(ArrayList<ViewItem> newData) {
        this.hideLoadMore();
        if (newData == null || newData.size() < this.pageCount) {
            this.isLoadingCompleted = true;
        } else if (!this.isLoadingCompleted) {
            newData.add(this.getLoadMoreItem());
        }
        if (newData != null && newData.size() > 0) {
            int start = this.mDatas.size();
            this.mDatas.addAll(newData);
            this.notifyItemRangeInserted(start, this.mDatas.size() - 1);
        }
        this.isLoading = false;
    }

    @Override
    public void replaceAll(ArrayList<ViewItem> newData) {
        this.clearAll();
        this.addAll(newData);
    }

    public void setLoadMoreCallback(ILoadMoreCallback callback) {
        this.callback = callback;
    }

    public boolean getLoadingCompleted() {
        return this.isLoadingCompleted;
    }

    public void setLoadingCompleted(boolean isLoadingCompleted) {
        this.isLoadingCompleted = isLoadingCompleted;
    }

    private ViewItem getLoadMoreItem() {
        return new ViewItem(2015063009, null);
    }

    private void hideLoadMore() {
        int lastPosition = this.mDatas.size() - 1;
        if (lastPosition >= 0) {
            ViewItem viewItem = (ViewItem)this.mDatas.get(lastPosition);
            if (viewItem.viewType == 2015063009) {
                this.mDatas.remove(lastPosition);
                this.notifyDataSetChanged();
            }
        }
    }

    public static interface ILoadMoreCallback {
        public void loadMore(int var1);
    }
}

