/*
 * Decompiled with CFR 0.152.
 */
package com.leo.superrecyclerview.adapters;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonAdapter<T>
extends RecyclerView.Adapter<CommonViewHolder> {
    protected List<T> mDatas;

    public CommonAdapter(List<T> mDatas) {
        if (mDatas == null) {
            mDatas = new ArrayList<T>();
        }
        this.mDatas = mDatas;
    }

    public CommonViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(this.getLayoutId(viewType), parent, false);
        return new CommonViewHolder(itemView);
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    public void addItem(T viewItem) {
        if (this.mDatas != null) {
            this.mDatas.add(viewItem);
            this.notifyDataSetChanged();
        }
    }

    public void addAll(ArrayList<T> newData) {
        if (this.mDatas != null) {
            int start = this.mDatas.size();
            this.mDatas.addAll(newData);
            this.notifyItemRangeInserted(start, this.mDatas.size() - 1);
        }
    }

    public void replaceAll(ArrayList<T> newData) {
        this.clearAll();
        this.mDatas = newData;
        this.notifyItemRangeInserted(0, this.mDatas.size() - 1);
    }

    public void clearAll() {
        int size = this.mDatas.size();
        if (size > 0) {
            this.mDatas = new ArrayList<T>();
            this.notifyItemRangeRemoved(0, size);
        }
    }

    public abstract int getLayoutId(int var1);

    public static class CommonViewHolder
    extends RecyclerView.ViewHolder {
        private final SparseArray<View> mViews = new SparseArray();

        public CommonViewHolder(View itemView) {
            super(itemView);
        }

        public <T extends View> T getView(int viewId) {
            View view = (View)this.mViews.get(viewId);
            if (view == null) {
                view = this.itemView.findViewById(viewId);
                this.mViews.put(viewId, (Object)view);
            }
            return (T)view;
        }

        public void setText(int viewId, String text) {
            TextView view = (TextView)this.getView(viewId);
            view.setText((CharSequence)text);
        }

        public void setImageResource(int viewId, int drawableId) {
            ImageView view = (ImageView)this.getView(viewId);
            view.setImageResource(drawableId);
        }

        public void setOnClickListener(int viewId, View.OnClickListener clickListener) {
            this.getView(viewId).setOnClickListener(clickListener);
        }

        public void setOnItemClickListener(View.OnClickListener clickListener) {
            this.itemView.setOnClickListener(clickListener);
        }
    }
}

