/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils.system;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.bubing.camera.utils.system.MeiZuStatusUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SystemUtils {
    private static SystemUtils instance = null;
    private Boolean hasNavigation = null;

    private SystemUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemUtils getInstance() {
        if (null != instance) return instance;
        Class<SystemUtils> clazz = SystemUtils.class;
        synchronized (SystemUtils.class) {
            if (null != instance) return instance;
            instance = new SystemUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean hasNavigationBar(Activity activity) {
        if (null == this.hasNavigation) {
            if (Build.VERSION.SDK_INT >= 17) {
                int windowHeight = activity.getResources().getDisplayMetrics().heightPixels;
                DisplayMetrics dm = new DisplayMetrics();
                activity.getWindowManager().getDefaultDisplay().getRealMetrics(dm);
                int screenHeight = dm.heightPixels;
                this.hasNavigation = screenHeight - windowHeight > 0;
            } else {
                this.hasNavigation = true;
            }
        }
        return this.hasNavigation;
    }

    public void systemUiInit(Activity activity, View decorView) {
        if (!this.hasNavigationBar(activity)) {
            activity.getWindow().addFlags(256);
            activity.getWindow().addFlags(512);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(512);
        }
    }

    private void hideStatusBar(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags |= 0x400;
        activity.getWindow().setAttributes(attrs);
    }

    private void showStatusBar(Activity activity) {
        WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
        attrs.flags &= 0xFFFFFBFF;
        activity.getWindow().setAttributes(attrs);
    }

    public void systemUiHide(Activity activity, View decorView) {
        if (!this.hasNavigationBar(activity)) {
            this.hideStatusBar(activity);
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            decorView.setSystemUiVisibility(4871);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(775);
        }
    }

    public void systemUiShow(Activity activity, View decorView) {
        if (!this.hasNavigationBar(activity)) {
            this.showStatusBar(activity);
            return;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            decorView.setSystemUiVisibility(1536);
        }
    }

    public int getStatusBarHeight(Context cxt) {
        int statusBarHeight = 0;
        int resourceId = cxt.getResources().getIdentifier("status_bar_height", "dimen", "android");
        statusBarHeight = resourceId > 0 ? cxt.getResources().getDimensionPixelSize(resourceId) : (int)(23.0f * cxt.getResources().getDisplayMetrics().density + 0.5f);
        return statusBarHeight;
    }

    public void setStatusDark(Activity activity, boolean darkmode) {
        if (this.isFlymeV4OrAbove()) {
            MeiZuStatusUtils.setStatusBarDarkIcon(activity, darkmode);
            return;
        }
        if (this.isMIUIV6OrAbove()) {
            this.setStatusTextBlackMi(activity, darkmode);
            return;
        }
        this.setStatusTextBlackAndroid(activity, darkmode);
    }

    private void setStatusTextBlackMi(Activity activity, boolean darkmode) {
        Class<?> clazz = activity.getWindow().getClass();
        try {
            int darkModeFlag = 0;
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)activity.getWindow(), darkmode ? darkModeFlag : 0, darkModeFlag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setStatusTextBlackAndroid(activity, darkmode);
    }

    private void setStatusTextBlackAndroid(Activity activity, boolean darkmode) {
        if (Build.VERSION.SDK_INT >= 23) {
            Window window = activity.getWindow();
            if (darkmode) {
                window.addFlags(Integer.MIN_VALUE);
                window.clearFlags(0x4000000);
                window.getDecorView().setSystemUiVisibility(8192);
            } else {
                int flag = window.getDecorView().getSystemUiVisibility() & 0xFFFFDFFF;
                window.getDecorView().setSystemUiVisibility(flag);
            }
        }
    }

    private boolean isFlymeV4OrAbove() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            String[] displayIdArray;
            for (String temp : displayIdArray = displayId.split(" ")) {
                if (!temp.matches("^[4-9]\\.(\\d+\\.)+\\S*")) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isMIUIV6OrAbove() {
        String miuiVersionCodeStr = this.getSystemProperty("ro.miui.ui.version.code");
        if (!TextUtils.isEmpty((CharSequence)miuiVersionCodeStr)) {
            try {
                int miuiVersionCode = Integer.parseInt(miuiVersionCodeStr);
                if (miuiVersionCode >= 4) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isAndroidMOrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSystemProperty(String propName) {
        String line;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + propName);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            String string2 = null;
            return string2;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return line;
    }
}

