/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import androidx.core.content.FileProvider;
import com.bubing.camera.exception.BException;
import com.bubing.camera.exception.BExceptionType;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.ImageFiles;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class UriUtils {
    private static final String TAG = "UriUtils";

    public static final String getFileProviderName(Context context) {
        return context.getPackageName() + ".fileprovider";
    }

    public static Uri getUri(Context cxt, File file) {
        if (Build.VERSION.SDK_INT >= 24) {
            return FileProvider.getUriForFile((Context)cxt, (String)UriUtils.getFileProviderName(cxt), (File)file);
        }
        return Uri.fromFile((File)file);
    }

    @SuppressLint(value={"NewApi"})
    public static String getPathByUri(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (UriUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    if (Build.VERSION.SDK_INT < 29) {
                        return Environment.getExternalStorageDirectory() + "/" + split[1];
                    }
                    return context.getExternalFilesDir(Environment.DIRECTORY_PICTURES) + "/" + split[1];
                }
            } else {
                if (UriUtils.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id2));
                    return UriUtils.getDataColumn(context, contentUri, null, null);
                }
                if (UriUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return UriUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (UriUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return UriUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        catch (IllegalArgumentException ex) {
            BubingLog.i(TAG, String.format(Locale.getDefault(), "getDataColumn: _data - [%s]", ex.getMessage()));
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    private static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    private static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    private static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    public static boolean isGooglePlayPhotosUri(Uri uri) {
        return "com.google.android.apps.photos.contentprovider".equals(uri.getAuthority());
    }

    public static Uri getUriByPath(Context context, String path) {
        Uri contentUri;
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(contentUri = MediaStore.Files.getContentUri((String)"external"), new String[]{"_id"}, "_data=? ", new String[]{path}, null);
        if (cursor != null && cursor.moveToFirst()) {
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            cursor.close();
            return Uri.withAppendedPath((Uri)contentUri, (String)("" + id2));
        }
        if (new File(path).exists()) {
            ContentValues values = new ContentValues();
            values.put("_data", path);
            return contentResolver.insert(contentUri, values);
        }
        return null;
    }

    public static String parseOwnUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        String path = TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)UriUtils.getFileProviderName(context)) ? new File(uri.getPath().replace("camera_photos/", "")).getAbsolutePath() : uri.getPath();
        return path;
    }

    public static Uri getTempUri(Context context, String path) {
        File file = new File(path);
        return UriUtils.getTempUri(context, file);
    }

    public static Uri getTempUri(Context context, File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return UriUtils.getUriForFile(context, file);
    }

    public static Uri getTempUri(Context context) {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.getDefault()).format(new Date());
        File file = new File(Environment.getExternalStorageDirectory(), "/images/" + timeStamp + ".jpg");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return UriUtils.getUriForFile(context, file);
    }

    public static Uri getUriForFile(Context context, File file) {
        return FileProvider.getUriForFile((Context)context, (String)UriUtils.getFileProviderName(context), (File)file);
    }

    public static Uri convertFileUriToFileProviderUri(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        if ("file".equals(uri.getScheme())) {
            return UriUtils.getUriForFile(context, new File(uri.getPath()));
        }
        return uri;
    }

    public static String getFilePathWithUri(Uri uri, Activity activity) throws BException {
        String picturePath;
        if (uri == null) {
            BubingLog.w(TAG, "uri is null,activity may have been recovered?");
            throw new BException(BExceptionType.TYPE_URI_NULL);
        }
        File picture = UriUtils.getFileWithUri(uri, activity);
        String string2 = picturePath = picture == null ? null : picture.getPath();
        if (TextUtils.isEmpty((CharSequence)picturePath)) {
            throw new BException(BExceptionType.TYPE_URI_PARSE_FAIL);
        }
        if (!ImageFiles.checkMimeType((Context)activity, ImageFiles.getMimeType(activity, uri))) {
            throw new BException(BExceptionType.TYPE_NOT_IMAGE);
        }
        return picturePath;
    }

    public static File getFileWithUri(Uri uri, Activity activity) {
        String picturePath = null;
        String scheme = uri.getScheme();
        if ("content".equals(scheme)) {
            String[] filePathColumn = new String[]{"_data"};
            Cursor cursor = activity.getContentResolver().query(uri, filePathColumn, null, null, null);
            cursor.moveToFirst();
            int columnIndex = cursor.getColumnIndex(filePathColumn[0]);
            if (columnIndex >= 0) {
                picturePath = cursor.getString(columnIndex);
            } else if (TextUtils.equals((CharSequence)uri.getAuthority(), (CharSequence)UriUtils.getFileProviderName((Context)activity))) {
                picturePath = UriUtils.parseOwnUri((Context)activity, uri);
            }
            cursor.close();
        } else if ("file".equals(scheme)) {
            picturePath = uri.getPath();
        }
        return TextUtils.isEmpty(picturePath) ? null : new File(picturePath);
    }

    public static String getFilePathWithDocumentsUri(Uri uri, Activity activity) throws BException {
        if (uri == null) {
            BubingLog.e(TAG, "uri is null,activity may have been recovered?");
            return null;
        }
        if ("content".equals(uri.getScheme()) && uri.getPath().contains("document")) {
            File tempFile = ImageFiles.getTempFile(activity, uri);
            try {
                ImageFiles.inputStreamToFile(activity.getContentResolver().openInputStream(uri), tempFile);
                return tempFile.getPath();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new BException(BExceptionType.TYPE_NO_FIND);
            }
        }
        return UriUtils.getFilePathWithUri(uri, activity);
    }
}

