/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtils {
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat DATE_FORMAT_DATE = new SimpleDateFormat("yyyy-MM-dd");

    private TimeUtils() {
        throw new AssertionError();
    }

    public static String getTime(long timeInMillis, SimpleDateFormat dateFormat) {
        return dateFormat.format(new Date(timeInMillis));
    }

    public static String dtFormat(Date date, String dateFormat) {
        return TimeUtils.getFormat(dateFormat).format(date);
    }

    private static DateFormat getFormat(String format) {
        return new SimpleDateFormat(format);
    }

    public static String getTime(long timeInMillis) {
        return TimeUtils.getTime(timeInMillis, DEFAULT_DATE_FORMAT);
    }

    public static long getCurrentTimeInLong() {
        return System.currentTimeMillis();
    }

    public static String getCurrentTimeInString() {
        return TimeUtils.getTime(TimeUtils.getCurrentTimeInLong());
    }

    public static String getCurrentTimeInString(SimpleDateFormat dateFormat) {
        return TimeUtils.getTime(TimeUtils.getCurrentTimeInLong(), dateFormat);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 == year2) {
            System.out.println("\u5224\u65adday2 - day1 : " + (day2 - day1));
            return day2 - day1;
        }
        int timeDistance = 0;
        for (int i = year1; i < year2; ++i) {
            if ((i % 4 != 0 || i % 100 == 0) && i % 400 != 0) {
                timeDistance += 365;
                continue;
            }
            timeDistance += 366;
        }
        return timeDistance + (day2 - day1);
    }
}

