/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import android.widget.Toast;
import com.bubing.camera.exception.BException;
import com.bubing.camera.exception.BExceptionType;
import com.bubing.camera.utils.BubingLog;
import com.bubing.camera.utils.FilePathUtils;
import com.bubing.camera.utils.UriUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageFiles {
    private static final String TAG = ImageFiles.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Bitmap bitmap, Uri imageUri) {
        if (bitmap == null) {
            return;
        }
        File file = new File(imageUri.getPath());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(bos.toByteArray());
            bos.flush();
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void inputStreamToFile(InputStream is, File file) throws BException {
        if (file == null) {
            BubingLog.i(TAG, "inputStreamToFile:file not be null");
            throw new BException(BExceptionType.TYPE_WRITE_FAIL);
        }
        FileOutputStream fos = null;
        try {
            int i;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            while ((i = is.read(buffer)) != -1) {
                fos.write(buffer, 0, i);
            }
        }
        catch (IOException e) {
            BubingLog.e(TAG, "InputStream \u5199\u5165\u6587\u4ef6\u51fa\u9519:" + e.toString());
            throw new BException(BExceptionType.TYPE_WRITE_FAIL);
        }
        finally {
            try {
                fos.flush();
                fos.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getCropTempFile(Activity context, Uri photoUri) throws BException {
        String minType = ImageFiles.getMimeType(context, photoUri);
        if (!ImageFiles.checkMimeType((Context)context, minType)) {
            throw new BException(BExceptionType.TYPE_NOT_IMAGE);
        }
        String filesPath = FilePathUtils.getInstance().getFileCacheDir((Context)context, FilePathUtils.FileType.TEMP);
        File file = new File(filesPath, "temp_crop_" + System.currentTimeMillis() + "." + minType);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    public static File getTempFile(Activity context, Uri photoUri) throws BException {
        String minType = ImageFiles.getMimeType(context, photoUri);
        if (!ImageFiles.checkMimeType((Context)context, minType)) {
            throw new BException(BExceptionType.TYPE_NOT_IMAGE);
        }
        File filesDir = context.getExternalFilesDir(Environment.DIRECTORY_PICTURES);
        if (!filesDir.exists()) {
            filesDir.mkdirs();
        }
        File photoFile = new File(filesDir, "temp_" + System.currentTimeMillis() + "." + minType);
        return photoFile;
    }

    public static boolean checkMimeType(Context context, String minType) {
        boolean isPicture;
        boolean bl = TextUtils.isEmpty((CharSequence)minType) ? false : (isPicture = ".jpg|.gif|.png|.bmp|.jpeg|.webp|".contains(minType.toLowerCase()));
        if (!isPicture) {
            Toast.makeText((Context)context, (CharSequence)"\u9009\u62e9\u7684\u4e0d\u662f\u56fe\u7247", (int)0).show();
        }
        return isPicture;
    }

    public static String getMimeType(Activity context, Uri uri) {
        String extension;
        if ("content".equals(uri.getScheme())) {
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(context.getContentResolver().getType(uri));
            if (TextUtils.isEmpty((CharSequence)extension)) {
                extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            }
        } else {
            extension = MimeTypeMap.getFileExtensionFromUrl((String)Uri.fromFile((File)new File(uri.getPath())).toString());
            if (TextUtils.isEmpty((CharSequence)extension)) {
                extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(context.getContentResolver().getType(uri));
            }
        }
        if (TextUtils.isEmpty((CharSequence)extension)) {
            extension = ImageFiles.getMimeTypeByFileName(UriUtils.getFileWithUri(uri, context).getName());
        }
        return extension;
    }

    public static String getMimeTypeByFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf("."), fileName.length());
    }
}

