/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.bubing.camera.R;
import com.bubing.camera.models.ad.AdViewHolder;
import com.bubing.camera.models.album.entity.AlbumItem;
import com.bubing.camera.setting.Setting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class AlbumItemsAdapter
extends RecyclerView.Adapter {
    private static final int TYPE_AD = 0;
    private static final int TYPE_ALBUM_ITEMS = 1;
    private ArrayList<Object> dataList;
    private LayoutInflater mInflater;
    private int selectedPosition;
    private OnClickListener listener;
    private int adPosition = 0;
    private int padding = 0;
    private boolean clearAd = false;

    public AlbumItemsAdapter(Context cxt, ArrayList<Object> list, int selectedPosition, OnClickListener listener) {
        this.dataList = list;
        this.mInflater = LayoutInflater.from((Context)cxt);
        this.listener = listener;
        this.selectedPosition = selectedPosition;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        switch (viewType) {
            case 0: {
                return new AdViewHolder(this.mInflater.inflate(R.layout.item_photos_ad, parent, false));
            }
        }
        return new AlbumItemsViewHolder(this.mInflater.inflate(R.layout.item_album_photos, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        final int p = position;
        if (holder instanceof AlbumItemsViewHolder) {
            if (this.padding == 0) {
                this.padding = ((AlbumItemsViewHolder)holder).mRoot.getPaddingLeft();
            }
            if (p == this.getItemCount() - 1) {
                ((AlbumItemsViewHolder)holder).mRoot.setPadding(this.padding, this.padding, this.padding, this.padding);
            } else {
                ((AlbumItemsViewHolder)holder).mRoot.setPadding(this.padding, this.padding, this.padding, 0);
            }
            AlbumItem item = (AlbumItem)this.dataList.get(p);
            Setting.imageEngine.loadPhoto(((AlbumItemsViewHolder)holder).ivAlbumCover.getContext(), item.coverImageUri, ((AlbumItemsViewHolder)holder).ivAlbumCover);
            ((AlbumItemsViewHolder)holder).tvAlbumName.setText((CharSequence)item.name);
            ((AlbumItemsViewHolder)holder).tvAlbumPhotosCount.setText((CharSequence)String.valueOf(item.photos.size()));
            if (this.selectedPosition == p) {
                ((AlbumItemsViewHolder)holder).ivSelected.setVisibility(0);
            } else {
                ((AlbumItemsViewHolder)holder).ivSelected.setVisibility(4);
            }
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int realPosition = p;
                    if (Setting.hasAlbumItemsAd() && p > AlbumItemsAdapter.this.adPosition) {
                        --realPosition;
                    }
                    int tempSelected = AlbumItemsAdapter.this.selectedPosition;
                    AlbumItemsAdapter.this.selectedPosition = p;
                    AlbumItemsAdapter.this.notifyItemChanged(tempSelected);
                    AlbumItemsAdapter.this.notifyItemChanged(p);
                    AlbumItemsAdapter.this.listener.onAlbumItemClick(p, realPosition);
                }
            });
            return;
        }
        if (holder instanceof AdViewHolder) {
            View adView;
            if (this.clearAd) {
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            this.adPosition = p;
            if (!Setting.albumItemsAdIsOk) {
                ((AdViewHolder)holder).adFrame.setVisibility(8);
                return;
            }
            WeakReference weakReference = (WeakReference)this.dataList.get(p);
            if (null != weakReference && null != (adView = (View)weakReference.get())) {
                if (null != adView.getParent() && adView.getParent() instanceof FrameLayout) {
                    ((FrameLayout)adView.getParent()).removeAllViews();
                }
                ((AdViewHolder)holder).adFrame.setVisibility(0);
                ((AdViewHolder)holder).adFrame.removeAllViews();
                ((AdViewHolder)holder).adFrame.addView(adView);
            }
        }
    }

    public void clearAd() {
        this.clearAd = true;
        this.notifyDataSetChanged();
    }

    public void setSelectedPosition(int position) {
        int realPosition = position;
        if (Setting.hasAlbumItemsAd() && position > this.adPosition) {
            --realPosition;
        }
        int tempSelected = this.selectedPosition;
        this.selectedPosition = position;
        this.notifyItemChanged(tempSelected);
        this.notifyItemChanged(position);
        this.listener.onAlbumItemClick(position, realPosition);
    }

    public int getItemCount() {
        return this.dataList.size();
    }

    public int getItemViewType(int position) {
        Object item = this.dataList.get(position);
        if (null == item || item instanceof WeakReference) {
            return 0;
        }
        return 1;
    }

    public class AlbumItemsViewHolder
    extends RecyclerView.ViewHolder {
        ImageView ivAlbumCover;
        TextView tvAlbumName;
        TextView tvAlbumPhotosCount;
        ImageView ivSelected;
        ConstraintLayout mRoot;

        AlbumItemsViewHolder(View itemView) {
            super(itemView);
            this.ivAlbumCover = (ImageView)itemView.findViewById(R.id.iv_album_cover);
            this.tvAlbumName = (TextView)itemView.findViewById(R.id.tv_album_name);
            this.tvAlbumPhotosCount = (TextView)itemView.findViewById(R.id.tv_album_photos_count);
            this.ivSelected = (ImageView)itemView.findViewById(R.id.iv_selected);
            this.mRoot = (ConstraintLayout)itemView.findViewById(R.id.m_root_view);
        }
    }

    public static interface OnClickListener {
        public void onAlbumItemClick(int var1, int var2);
    }
}

