/*
 * Decompiled with CFR 0.152.
 */
package com.bubing.camera.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.bubing.camera.R;
import com.bubing.camera.models.album.AlbumModel;
import com.bubing.camera.models.album.entity.Photo;
import com.bubing.camera.result.ResultStorage;
import com.bubing.camera.setting.Setting;
import com.bubing.camera.ui.ImagePreviewFragment;
import com.bubing.camera.ui.adapter.PreviewPhotosAdapter;
import com.bubing.camera.utils.ColorUtils;
import com.bubing.camera.utils.system.SystemUtils;
import com.bubing.camera.widget.PressedTextView;
import java.util.ArrayList;

public class ImagePreviewActivity
extends AppCompatActivity
implements PreviewPhotosAdapter.OnClickListener,
View.OnClickListener,
ImagePreviewFragment.OnPreviewFragmentClickListener {
    private static final int UI_ANIMATION_DELAY = 300;
    private final Handler mHideHandler = new Handler();
    private final Runnable mHidePart2Runnable = new Runnable(){

        @Override
        public void run() {
            SystemUtils.getInstance().systemUiHide((Activity)ImagePreviewActivity.this, ImagePreviewActivity.this.decorView);
        }
    };
    private RelativeLayout mBottomBar;
    private FrameLayout mToolBar;
    private final Runnable mShowPart2Runnable = new Runnable(){

        @Override
        public void run() {
            ImagePreviewActivity.this.mBottomBar.setVisibility(0);
            ImagePreviewActivity.this.mToolBar.setVisibility(0);
        }
    };
    private boolean mVisible;
    View decorView;
    private TextView tvOriginal;
    private TextView tvNumber;
    private PressedTextView tvDone;
    private ImageView ivSelector;
    private RecyclerView rvPhotos;
    private PreviewPhotosAdapter adapter;
    private PagerSnapHelper snapHelper;
    private LinearLayoutManager lm;
    private int index;
    private ArrayList<Photo> photos = new ArrayList();
    private int resultCode = 0;
    private int lastPosition = 0;
    private boolean isSingle = Setting.count == 1;
    private boolean unable = ResultStorage.count() == Setting.count;
    private FrameLayout flFragment;
    private ImagePreviewFragment previewFragment;
    private int statusColor;

    public static void start(Activity act, int albumItemIndex, int currIndex) {
        Intent intent = new Intent((Context)act, ImagePreviewActivity.class);
        intent.putExtra("keyOfPreviewAlbumItemIndex", albumItemIndex);
        intent.putExtra("keyOfPreviewPhotoIndex", currIndex);
        act.startActivityForResult(intent, 13);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.decorView = this.getWindow().getDecorView();
        SystemUtils.getInstance().systemUiInit((Activity)this, this.decorView);
        this.setContentView(R.layout.activity_preview_photos);
        this.hideActionBar();
        this.adaptationStatusBar();
        if (null == AlbumModel.instance) {
            this.finish();
            return;
        }
        this.initData();
        this.initView();
    }

    private void adaptationStatusBar() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.statusColor = ContextCompat.getColor((Context)this, (int)R.color.status_bar);
            if (ColorUtils.isWhiteColor(this.statusColor)) {
                this.getWindow().addFlags(0x4000000);
            }
        }
    }

    private void hideActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    private void initData() {
        Intent intent = this.getIntent();
        int albumItemIndex = intent.getIntExtra("keyOfPreviewAlbumItemIndex", 0);
        this.photos.clear();
        if (albumItemIndex == -1) {
            this.photos.addAll(ResultStorage.photos);
        } else {
            this.photos.addAll(AlbumModel.instance.getCurrAlbumItemPhotos(albumItemIndex));
        }
        this.lastPosition = this.index = intent.getIntExtra("keyOfPreviewPhotoIndex", 0);
        this.mVisible = true;
    }

    private void toggle() {
        if (this.mVisible) {
            this.hide();
        } else {
            this.show();
        }
    }

    private void hide() {
        AlphaAnimation hideAnimation = new AlphaAnimation(1.0f, 0.0f);
        hideAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                ImagePreviewActivity.this.mBottomBar.setVisibility(8);
                ImagePreviewActivity.this.mToolBar.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        hideAnimation.setDuration(300L);
        this.mBottomBar.startAnimation((Animation)hideAnimation);
        this.mToolBar.startAnimation((Animation)hideAnimation);
        this.mVisible = false;
        this.mHideHandler.removeCallbacks(this.mShowPart2Runnable);
        this.mHideHandler.postDelayed(this.mHidePart2Runnable, 300L);
    }

    private void show() {
        if (Build.VERSION.SDK_INT >= 16) {
            SystemUtils.getInstance().systemUiShow((Activity)this, this.decorView);
        }
        this.mVisible = true;
        this.mHideHandler.removeCallbacks(this.mHidePart2Runnable);
        this.mHideHandler.post(this.mShowPart2Runnable);
    }

    @Override
    public void onPhotoClick() {
        this.toggle();
    }

    @Override
    public void onPhotoScaleChanged() {
        if (this.mVisible) {
            this.hide();
        }
    }

    public void onBackPressed() {
        this.doBack();
    }

    private void doBack() {
        Intent intent = new Intent();
        intent.putExtra("keyOfPreviewClickDone", false);
        this.setResult(this.resultCode, intent);
        this.finish();
    }

    private void initView() {
        this.setClick(R.id.iv_back, R.id.tv_edit, R.id.tv_selector);
        this.mToolBar = (FrameLayout)this.findViewById(R.id.m_top_bar_layout);
        if (!SystemUtils.getInstance().hasNavigationBar((Activity)this)) {
            FrameLayout mRootView = (FrameLayout)this.findViewById(R.id.m_root_view);
            mRootView.setFitsSystemWindows(true);
            this.mToolBar.setPadding(0, SystemUtils.getInstance().getStatusBarHeight((Context)this), 0, 0);
            if (ColorUtils.isWhiteColor(this.statusColor)) {
                SystemUtils.getInstance().setStatusDark((Activity)this, true);
            }
        }
        this.mBottomBar = (RelativeLayout)this.findViewById(R.id.m_bottom_bar);
        this.ivSelector = (ImageView)this.findViewById(R.id.iv_selector);
        this.tvNumber = (TextView)this.findViewById(R.id.tv_number);
        this.tvDone = (PressedTextView)this.findViewById(R.id.tv_done);
        this.tvOriginal = (TextView)this.findViewById(R.id.tv_original);
        this.flFragment = (FrameLayout)this.findViewById(R.id.fl_fragment);
        this.previewFragment = (ImagePreviewFragment)this.getSupportFragmentManager().findFragmentById(R.id.fragment_preview);
        if (Setting.showOriginalMenu) {
            this.processOriginalMenu();
        } else {
            this.tvOriginal.setVisibility(8);
        }
        this.setClick(new View[]{this.tvOriginal, this.tvDone, this.ivSelector});
        this.initRecyclerView();
        this.shouldShowMenuDone();
    }

    private void initRecyclerView() {
        this.rvPhotos = (RecyclerView)this.findViewById(R.id.rv_photos);
        this.adapter = new PreviewPhotosAdapter((Context)this, this.photos, this);
        this.lm = new LinearLayoutManager((Context)this, 0, false);
        this.rvPhotos.setLayoutManager((RecyclerView.LayoutManager)this.lm);
        this.rvPhotos.setAdapter((RecyclerView.Adapter)this.adapter);
        this.rvPhotos.scrollToPosition(this.index);
        this.toggleSelector();
        this.snapHelper = new PagerSnapHelper();
        this.snapHelper.attachToRecyclerView(this.rvPhotos);
        this.rvPhotos.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                View view = ImagePreviewActivity.this.snapHelper.findSnapView((RecyclerView.LayoutManager)ImagePreviewActivity.this.lm);
                if (view == null) {
                    return;
                }
                int position = ImagePreviewActivity.this.lm.getPosition(view);
                if (ImagePreviewActivity.this.lastPosition == position) {
                    return;
                }
                ImagePreviewActivity.this.lastPosition = position;
                ImagePreviewActivity.this.previewFragment.setSelectedPosition(-1);
                ImagePreviewActivity.this.tvNumber.setText((CharSequence)ImagePreviewActivity.this.getString(R.string.preview_current_number, new Object[]{ImagePreviewActivity.this.lastPosition + 1, ImagePreviewActivity.this.photos.size()}));
                ImagePreviewActivity.this.toggleSelector();
            }
        });
        this.tvNumber.setText((CharSequence)this.getString(R.string.preview_current_number, new Object[]{this.index + 1, this.photos.size()}));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (R.id.iv_back == id2) {
            this.doBack();
        } else if (R.id.tv_selector == id2) {
            this.updateSelector();
        } else if (R.id.iv_selector == id2) {
            this.updateSelector();
        } else if (R.id.tv_original == id2) {
            if (!Setting.originalMenuUsable) {
                Toast.makeText((Context)this, (CharSequence)Setting.originalMenuUnusableHint, (int)0).show();
                return;
            }
            Setting.selectedOriginal = !Setting.selectedOriginal;
            this.processOriginalMenu();
        } else if (R.id.tv_done == id2) {
            Intent intent = new Intent();
            intent.putExtra("keyOfPreviewClickDone", true);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void processOriginalMenu() {
        if (Setting.selectedOriginal) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_accent));
        } else if (Setting.originalMenuUsable) {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_primary));
        } else {
            this.tvOriginal.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.fg_primary_dark));
        }
    }

    private void toggleSelector() {
        if (this.photos.get((int)this.lastPosition).selected) {
            this.ivSelector.setImageResource(R.drawable.ic_selector_true);
            if (!ResultStorage.isEmpty()) {
                for (int i = 0; i < ResultStorage.count(); ++i) {
                    if (!this.photos.get((int)this.lastPosition).path.equals(ResultStorage.getPhotoPath(i))) continue;
                    this.previewFragment.setSelectedPosition(i);
                    break;
                }
            }
        } else {
            this.ivSelector.setImageResource(R.drawable.ic_selector);
        }
        this.previewFragment.notifyDataSetChanged();
        this.shouldShowMenuDone();
    }

    private void updateSelector() {
        this.resultCode = -1;
        Photo item = this.photos.get(this.lastPosition);
        if (this.isSingle) {
            this.singleSelector(item);
            return;
        }
        if (this.unable) {
            if (item.selected) {
                ResultStorage.removePhoto(item);
                if (this.unable) {
                    this.unable = false;
                }
                this.toggleSelector();
                return;
            }
            if (Setting.isOnlyVideo()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_video_hint, new Object[]{Setting.count}), (int)0).show();
            } else if (Setting.showVideo) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_hint, new Object[]{Setting.count}), (int)0).show();
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint, new Object[]{Setting.count}), (int)0).show();
            }
            return;
        }
        boolean bl = item.selected = !item.selected;
        if (item.selected) {
            int res = ResultStorage.addPhoto(item);
            if (res != 0) {
                item.selected = false;
                switch (res) {
                    case -1: {
                        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_image_hint, new Object[]{Setting.pictureCount}), (int)0).show();
                        break;
                    }
                    case -2: {
                        Toast.makeText((Context)this, (CharSequence)this.getString(R.string.selector_reach_max_video_hint, new Object[]{Setting.videoCount}), (int)0).show();
                    }
                }
                return;
            }
            if (ResultStorage.count() == Setting.count) {
                this.unable = true;
            }
        } else {
            ResultStorage.removePhoto(item);
            this.previewFragment.setSelectedPosition(-1);
            if (this.unable) {
                this.unable = false;
            }
        }
        this.toggleSelector();
    }

    private void singleSelector(Photo photo) {
        if (!ResultStorage.isEmpty()) {
            if (ResultStorage.getPhotoPath(0).equals(photo.path)) {
                ResultStorage.removePhoto(photo);
                this.toggleSelector();
            } else {
                ResultStorage.removePhoto(0);
                ResultStorage.addPhoto(photo);
                this.toggleSelector();
            }
        } else {
            ResultStorage.addPhoto(photo);
            this.toggleSelector();
        }
    }

    private void shouldShowMenuDone() {
        if (ResultStorage.isEmpty()) {
            if (0 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleHide = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f);
                scaleHide.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleHide);
            }
            this.tvDone.setVisibility(8);
            this.flFragment.setVisibility(8);
        } else {
            if (8 == this.tvDone.getVisibility()) {
                ScaleAnimation scaleShow = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f);
                scaleShow.setDuration(200L);
                this.tvDone.startAnimation((Animation)scaleShow);
            }
            this.flFragment.setVisibility(0);
            this.tvDone.setVisibility(0);
            this.tvDone.setText(this.getString(R.string.selector_action_done, new Object[]{ResultStorage.count(), Setting.count}));
        }
    }

    @Override
    public void onPreviewPhotoClick(int position) {
        String path = ResultStorage.getPhotoPath(position);
        for (int i = 0; i < this.photos.size(); ++i) {
            if (!TextUtils.equals((CharSequence)path, (CharSequence)this.photos.get((int)i).path)) continue;
            this.rvPhotos.scrollToPosition(i);
            this.lastPosition = i;
            this.tvNumber.setText((CharSequence)this.getString(R.string.preview_current_number, new Object[]{this.lastPosition + 1, this.photos.size()}));
            this.previewFragment.setSelectedPosition(position);
            this.toggleSelector();
            return;
        }
    }

    private void setClick(int ... ids) {
        for (int id2 : ids) {
            this.findViewById(id2).setOnClickListener((View.OnClickListener)this);
        }
    }

    private void setClick(View ... views) {
        for (View v : views) {
            v.setOnClickListener((View.OnClickListener)this);
        }
    }
}

